/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.util;

import java.lang.reflect.Method;
import org.jruby.BasicObjectStub;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.ClassVisitor;

public class BasicObjectStubGenerator {
    private static final Method[] BASIC_OBJECT_STUB_METHODS = BasicObjectStub.class.getDeclaredMethods();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addBasicObjectStubsToClass(ClassVisitor cv) {
        for (Method stub : BASIC_OBJECT_STUB_METHODS) {
            if (stub.getName().equals("getRuntime") || stub.getName().equals("getMetaClass")) continue;
            Class[] signature = new Class[stub.getParameterTypes().length - 1];
            for (int i2 = 0; i2 < signature.length; ++i2) {
                signature[i2] = stub.getParameterTypes()[i2 + 1];
            }
            SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(cv, 65, stub.getName(), CodegenUtils.sig(stub.getReturnType(), signature), null, null);
            method2.start();
            method2.aload(0);
            int nextIndex = 1;
            for (Class argType : signature) {
                if (argType.isPrimitive()) {
                    if (argType == Boolean.TYPE || argType == Byte.TYPE || argType == Character.TYPE || argType == Short.TYPE || argType == Integer.TYPE) {
                        method2.iload(nextIndex);
                        ++nextIndex;
                        continue;
                    }
                    if (argType == Long.TYPE) {
                        method2.lload(nextIndex);
                        nextIndex += 2;
                        continue;
                    }
                    if (argType == Float.TYPE) {
                        method2.fload(nextIndex);
                        ++nextIndex;
                        continue;
                    }
                    if (argType != Double.TYPE) throw new RuntimeException("unknown primitive type: " + argType);
                    method2.dload(nextIndex);
                    nextIndex += 2;
                    continue;
                }
                method2.aload(nextIndex);
                ++nextIndex;
            }
            method2.invokestatic(CodegenUtils.p(BasicObjectStub.class), stub.getName(), CodegenUtils.sig(stub.getReturnType(), stub.getParameterTypes()));
            Class<?> retType = stub.getReturnType();
            if (retType == Void.TYPE) {
                method2.voidreturn();
            } else if (retType.isPrimitive()) {
                if (retType == Boolean.TYPE || retType == Byte.TYPE || retType == Character.TYPE || retType == Short.TYPE || retType == Integer.TYPE) {
                    method2.ireturn();
                } else if (retType == Long.TYPE) {
                    method2.lreturn();
                } else if (retType == Float.TYPE) {
                    method2.freturn();
                } else {
                    if (retType != Double.TYPE) throw new RuntimeException("unknown primitive type: " + retType);
                    method2.dreturn();
                }
            } else {
                method2.areturn();
            }
            method2.end();
        }
    }
}

