/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArgsCatNode
extends Node {
    private final Node firstNode;
    private final Node secondNode;

    public ArgsCatNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position);
        assert (firstNode != null) : "ArgsCatNode.first == null";
        assert (secondNode != null) : "ArgsCatNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGSCATNODE;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitArgsCatNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        IRubyObject args2 = this.firstNode.interpret(runtime, context, self2, aBlock);
        IRubyObject secondInterpret = this.secondNode.interpret(runtime, context, self2, aBlock);
        return Helpers.argsCat(args2, secondInterpret);
    }
}

