/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.cext;

import java.lang.ref.Reference;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.RubyBasicObject;
import org.jruby.cext.Cleaner;
import org.jruby.cext.GIL;
import org.jruby.cext.Handle;
import org.jruby.cext.Native;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.WeakIdentityHashMap;
import org.jruby.util.WeakReferenceReaper;

public class GC {
    private static final Map<Object, Handle> nativeHandles = new WeakIdentityHashMap();
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
    private static volatile Reference<Object> reaper = null;
    private static Runnable gcTask;
    private static volatile Future<?> gcFuture;
    private static final AtomicInteger gcDisable;

    public static final void mark(IRubyObject obj) {
    }

    public static final void trigger() {
        if (gcFuture == null || gcFuture.isDone()) {
            gcFuture = executor.submit(gcTask);
        }
    }

    static void init(final Native n) {
        gcTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (gcDisable.get() == 0) {
                    GIL.acquire();
                    try {
                        n.gc();
                    }
                    finally {
                        GIL.releaseNoCleanup();
                    }
                }
            }
        };
    }

    static final Handle lookup(IRubyObject obj) {
        return obj instanceof RubyBasicObject ? (Handle)((RubyBasicObject)obj).getNativeHandle() : nativeHandles.get(obj);
    }

    static final void register(IRubyObject obj, Handle h) {
        if (obj instanceof RubyBasicObject) {
            ((RubyBasicObject)obj).setNativeHandle(h);
        } else {
            nativeHandles.put(obj, h);
        }
        Cleaner.register(h);
    }

    static final void cleanup() {
        if (reaper == null) {
            reaper = new WeakReferenceReaper<Object>(new Object()){

                @Override
                public void run() {
                    reaper = null;
                    GC.trigger();
                }
            };
        }
    }

    static void disable() {
        gcDisable.incrementAndGet();
    }

    static void enable() {
        if (gcDisable.decrementAndGet() == 0) {
            GC.cleanup();
        }
    }

    static {
        gcDisable = new AtomicInteger();
    }
}

