/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import com.kenai.constantine.platform.Fcntl;
import com.kenai.constantine.platform.OpenFlags;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.ffi.LastError;
import jnr.ffi.Library;
import jnr.ffi.Platform;
import jnr.ffi.Runtime;
import jnr.ffi.annotations.In;
import jnr.ffi.annotations.Out;
import jnr.ffi.annotations.Transient;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.SockAddrUnix;

class Native {
    static final String[] libnames;

    Native() {
    }

    static final LibC libsocket() {
        return LibC.INSTANCE;
    }

    static final LibC libc() {
        return LibC.INSTANCE;
    }

    static int socket(ProtocolFamily domain, Sock type2, int protocol2) throws IOException {
        int fd = Native.libsocket().socket(domain.intValue(), type2.intValue(), protocol2);
        if (fd < 0) {
            throw new IOException(Native.getLastErrorString());
        }
        return fd;
    }

    static int socketpair(ProtocolFamily domain, Sock type2, int protocol2, int[] sv) throws IOException {
        if (Native.libsocket().socketpair(domain.intValue(), type2.intValue(), protocol2, sv) < 0) {
            throw new IOException("socketpair(2) failed " + Native.getLastErrorString());
        }
        return 0;
    }

    static int listen(int fd, int backlog) {
        return Native.libsocket().listen(fd, backlog);
    }

    static int bind(int fd, SockAddrUnix addr2, int len) {
        return Native.libsocket().bind(fd, addr2, len);
    }

    static int accept(int fd, SockAddrUnix addr2, IntByReference len) {
        return Native.libsocket().accept(fd, addr2, len);
    }

    static int connect(int fd, SockAddrUnix addr2, int len) {
        return Native.libsocket().connect(fd, addr2, len);
    }

    static String getLastErrorString() {
        return Native.strerror(LastError.getLastError(Runtime.getSystemRuntime()));
    }

    static String strerror(int error2) {
        return Native.libc().strerror(error2);
    }

    public static void setBlocking(int fd, boolean block) {
        int flags = Native.libc().fcntl(fd, LibC.F_GETFL, 0);
        flags = block ? (flags &= ~LibC.O_NONBLOCK) : (flags |= LibC.O_NONBLOCK);
        Native.libc().fcntl(fd, LibC.F_SETFL, flags);
    }

    public static int setsockopt(int s2, SocketLevel level2, SocketOption optname2, boolean optval) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putInt(optval ? 1 : 0).flip();
        return Native.libsocket().setsockopt(s2, level2.intValue(), optname2.intValue(), buf, buf.remaining());
    }

    static {
        String[] stringArray;
        if (Platform.getNativePlatform().getOS() == Platform.OS.SOLARIS) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "socket";
            stringArray2[1] = "nsl";
            stringArray = stringArray2;
            stringArray2[2] = "c";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "c";
        }
        libnames = stringArray;
    }

    public static interface LibC {
        public static final LibC INSTANCE = Library.loadLibrary(LibC.class, libnames);
        public static final int F_GETFL = Fcntl.F_GETFL.value();
        public static final int F_SETFL = Fcntl.F_SETFL.value();
        public static final int O_NONBLOCK = OpenFlags.O_NONBLOCK.value();

        public int socket(int var1, int var2, int var3);

        public int listen(int var1, int var2);

        public int bind(int var1, @In @Out @Transient SockAddrUnix var2, int var3);

        public int accept(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int connect(int var1, @In @Transient SockAddrUnix var2, int var3);

        public int getsockname(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int getpeername(int var1, @Out SockAddrUnix var2, @In @Out IntByReference var3);

        public int socketpair(int var1, int var2, int var3, @Out int[] var4);

        public int fcntl(int var1, int var2, int var3);

        public int getsockopt(int var1, int var2, int var3, @Out ByteBuffer var4, @In @Out IntByReference var5);

        public int setsockopt(int var1, int var2, int var3, @In ByteBuffer var4, int var5);

        public String strerror(int var1);
    }
}

