/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.text.NumberFormat;
import java.text.ParsePosition;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.command.CommandResultStats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class ReduxCommandBlockTileEntity
extends TileEntity {
    private String packId = "";
    private Object[] lastEventArgs;
    protected volatile Block reduxBlock = null;
    protected int lastSuccessCount = 0;
    protected CommandResultStats.Type lastResultType = CommandResultStats.Type.SUCCESS_COUNT;
    protected int lastResultAmount = 0;

    public int getLastSuccessCount() {
        return this.lastSuccessCount;
    }

    public void init(String packId, Block reduxBlock) {
        this.packId = packId;
        this.reduxBlock = reduxBlock;
        this.setupTriggers();
    }

    public void setupTileEntity(String blockId) {
        Pack p = Redux.instance.getReduxConfiguration().getPackFromId(this.packId);
        if (p == null) {
            throw new AssertionError();
        }
        this.reduxBlock = p.getBlockFromId(blockId);
        if (this.reduxBlock == null) {
            throw new AssertionError();
        }
        this.setupTriggers();
    }

    private void setupTriggers() {
    }

    public boolean triggerSpecialEvent(Trigger.TriggerEvent event, Object ... args) {
        return false;
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("lastSuccessCount", this.lastSuccessCount);
        compound.setInteger(this.lastResultType.getTypeName(), this.lastResultAmount);
        compound.setString("pack", this.packId);
        compound.setString("block", this.reduxBlock.getId());
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.lastSuccessCount = compound.getInteger("lastSuccessCount");
        this.packId = compound.getString("pack");
        this.setupTileEntity(compound.getString("block"));
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.pos, 0, nbttagcompound);
    }

    protected static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }
}

