/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.zlib;

import com.jcraft.jzlib.Inflater;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.zlib.RubyZlib;
import org.jruby.ext.zlib.ZStream;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"Zlib::Inflate"}, parent="Zlib::ZStream")
public class JZlibInflate
extends ZStream {
    public static final int BASE_SIZE = 100;
    private int windowBits;
    private byte[] collected;
    private int collectedIdx;
    private ByteList input;
    private Inflater flater = null;
    protected static final ObjectAllocator INFLATE_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new JZlibInflate(runtime, klass);
        }
    };

    public JZlibInflate(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"inflate"}, required=1, meta=true)
    public static IRubyObject s_inflate(ThreadContext context, IRubyObject recv2, IRubyObject string2) {
        IRubyObject result2;
        RubyClass klass = (RubyClass)recv2;
        JZlibInflate inflate2 = (JZlibInflate)klass.allocate();
        inflate2.init(15);
        try {
            inflate2.append(string2.convertToString().getByteList());
        }
        finally {
            result2 = inflate2.finish(context);
            inflate2.close();
        }
        return result2;
    }

    @JRubyMethod(name={"initialize"}, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject _initialize(IRubyObject[] args2) {
        this.windowBits = 15;
        if (args2.length > 0 && !args2[0].isNil()) {
            this.windowBits = RubyNumeric.fix2int(args2[0]);
            JZlibInflate.checkWindowBits(this.getRuntime(), this.windowBits, true);
        }
        this.init(this.windowBits);
        return this;
    }

    private void init(int windowBits) {
        this.flater = new Inflater();
        this.flater.init(windowBits);
        this.collected = new byte[100];
        this.collectedIdx = 0;
        this.input = new ByteList();
    }

    @Override
    @JRubyMethod(name={"flush_next_out"})
    public IRubyObject flush_next_out(ThreadContext context) {
        return this.flushOutput(context.getRuntime());
    }

    private RubyString flushOutput(Ruby runtime) {
        if (this.collectedIdx > 0) {
            RubyString res = RubyString.newString(runtime, this.collected, 0, this.collectedIdx);
            this.collectedIdx = 0;
            this.flater.setOutput(this.collected);
            return res;
        }
        return RubyString.newEmptyString(runtime);
    }

    @JRubyMethod(name={"<<"}, required=1)
    public IRubyObject append(ThreadContext context, IRubyObject arg2) {
        this.checkClosed();
        if (arg2.isNil()) {
            this.run(true);
        } else {
            this.append(arg2.convertToString().getByteList());
        }
        return this;
    }

    public void append(ByteList obj) {
        if (!this.internalFinished()) {
            this.flater.setInput(obj.bytes(), true);
        } else {
            this.input.append(obj);
        }
        this.run(false);
    }

    @JRubyMethod(name={"sync_point?"})
    public IRubyObject sync_point_p() {
        return this.sync_point();
    }

    public IRubyObject sync_point() {
        int ret = this.flater.syncPoint();
        switch (ret) {
            case 1: {
                return this.getRuntime().getTrue();
            }
            case -3: {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
        }
        return this.getRuntime().getFalse();
    }

    @JRubyMethod(name={"set_dictionary"}, required=1)
    public IRubyObject set_dictionary(ThreadContext context, IRubyObject arg2) {
        try {
            return this.set_dictionary(arg2);
        }
        catch (IllegalArgumentException iae) {
            throw RubyZlib.newStreamError(context.getRuntime(), "stream error: " + iae.getMessage());
        }
    }

    private IRubyObject set_dictionary(IRubyObject str) {
        byte[] tmp = str.convertToString().getBytes();
        int ret = this.flater.setDictionary(tmp, tmp.length);
        switch (ret) {
            case -2: {
                throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
            }
            case -3: {
                throw RubyZlib.newDataError(this.getRuntime(), "wrong dictionary");
            }
        }
        this.run(false);
        return str;
    }

    @JRubyMethod(name={"inflate"}, required=1)
    public IRubyObject inflate(ThreadContext context, IRubyObject string2) {
        ByteList data2 = null;
        if (!string2.isNil()) {
            data2 = string2.convertToString().getByteList();
        }
        return this.inflate(context, data2);
    }

    public IRubyObject inflate(ThreadContext context, ByteList str) {
        if (null == str) {
            return this.internalFinish();
        }
        this.append(str);
        return this.flushOutput(context.getRuntime());
    }

    @JRubyMethod(name={"sync"}, required=1)
    public IRubyObject sync(ThreadContext context, IRubyObject string2) {
        if (this.flater.avail_in > 0) {
            switch (this.flater.sync()) {
                case 0: {
                    this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
                    return this.getRuntime().getTrue();
                }
                case -3: {
                    break;
                }
                default: {
                    throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
                }
            }
        }
        if (string2.convertToString().getByteList().length() <= 0) {
            return this.getRuntime().getFalse();
        }
        this.flater.setInput(string2.convertToString().getByteList().bytes(), true);
        switch (this.flater.sync()) {
            case 0: {
                return this.getRuntime().getTrue();
            }
            case -3: {
                return this.getRuntime().getFalse();
            }
        }
        throw RubyZlib.newStreamError(this.getRuntime(), "stream error");
    }

    private void run(boolean finish2) {
        int err;
        int resultLength = -1;
        Ruby runtime = this.getRuntime();
        while (!this.internalFinished() && resultLength != 0) {
            boolean needsInput;
            boolean bl = needsInput = this.flater.avail_in < 0;
            if (finish2 && needsInput) {
                throw RubyZlib.newBufError(runtime, "buffer error");
            }
            this.flater.setOutput(this.collected, this.collectedIdx, this.collected.length - this.collectedIdx);
            int ret = this.flater.inflate(0);
            resultLength = this.flater.next_out_index - this.collectedIdx;
            this.collectedIdx = this.flater.next_out_index;
            switch (ret) {
                case -3: {
                    throw RubyZlib.newDataError(runtime, this.flater.getMessage());
                }
                case 2: {
                    throw RubyZlib.newDictError(runtime, "need dictionary");
                }
                case 1: {
                    if (this.flater.avail_in > 0) {
                        this.input.append(this.flater.next_in, this.flater.next_in_index, this.flater.avail_in);
                        this.flater.setInput("".getBytes());
                    }
                }
                case 0: {
                    resultLength = this.flater.next_out_index;
                    break;
                }
                default: {
                    resultLength = 0;
                }
            }
            if (this.collected.length != this.collectedIdx || this.internalFinished()) continue;
            byte[] tmp = new byte[this.collected.length * 3];
            System.arraycopy(this.collected, 0, tmp, 0, this.collected.length);
            this.collected = tmp;
        }
        if (finish2 && !this.internalFinished() && (err = this.flater.inflate(4)) != 0) {
            throw RubyZlib.newBufError(this.getRuntime(), "buffer error");
        }
    }

    @Override
    protected int internalTotalIn() {
        return (int)this.flater.total_in;
    }

    @Override
    protected int internalTotalOut() {
        return (int)this.flater.total_out;
    }

    @Override
    protected boolean internalStreamEndP() {
        return this.flater.finished();
    }

    @Override
    protected void internalReset() {
        this.init(this.windowBits);
    }

    @Override
    protected boolean internalFinished() {
        return this.flater.finished();
    }

    @Override
    protected long internalAdler() {
        return this.flater.getAdler();
    }

    @Override
    protected IRubyObject internalFinish() {
        this.run(true);
        if (this.internalFinished() && this.input.getRealSize() > 0) {
            if (this.collected.length - this.collectedIdx < this.input.length()) {
                byte[] tmp = new byte[this.collected.length + this.input.length()];
                System.arraycopy(this.collected, 0, tmp, 0, this.collectedIdx);
                this.collected = tmp;
            }
            System.arraycopy(this.input.getUnsafeBytes(), this.input.begin(), this.collected, this.collectedIdx, this.input.length());
            this.collectedIdx += this.input.length();
            JZlibInflate.resetBuffer(this.input);
        }
        return this.flushOutput(this.getRuntime());
    }

    @Override
    protected void internalClose() {
        this.flater.end();
    }

    @Override
    public IRubyObject avail_in() {
        return this.getRuntime().newFixnum(this.flater.avail_in);
    }

    private static void resetBuffer(ByteList l) {
        l.setBegin(0);
        l.setRealSize(0);
        l.invalidate();
    }
}

