/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.InvalidTransformException;
import com.headius.invokebinder.transform.Cast;
import com.headius.invokebinder.transform.Catch;
import com.headius.invokebinder.transform.Collect;
import com.headius.invokebinder.transform.Convert;
import com.headius.invokebinder.transform.Drop;
import com.headius.invokebinder.transform.Filter;
import com.headius.invokebinder.transform.FilterReturn;
import com.headius.invokebinder.transform.Fold;
import com.headius.invokebinder.transform.Insert;
import com.headius.invokebinder.transform.Permute;
import com.headius.invokebinder.transform.Spread;
import com.headius.invokebinder.transform.Transform;
import com.headius.invokebinder.transform.TryFinally;
import com.headius.invokebinder.transform.Varargs;
import java.io.PrintStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class Binder {
    private final Logger logger = Logger.getLogger("Invoke Binder");
    private final List<Transform> transforms = new ArrayList<Transform>();
    private final List<MethodType> types = new ArrayList<MethodType>();
    private final MethodType start;
    private final MethodHandles.Lookup lookup;

    public Binder(MethodType start2) {
        this.start = start2;
        this.types.add(0, start2);
        this.lookup = MethodHandles.publicLookup();
    }

    public Binder(MethodHandles.Lookup lookup, MethodType start2) {
        this.start = start2;
        this.types.add(0, start2);
        this.lookup = lookup;
    }

    public Binder(Binder source2) {
        this.start = source2.start;
        this.types.addAll(source2.types);
        this.transforms.addAll(source2.transforms);
        this.lookup = source2.lookup;
    }

    public Binder(MethodHandles.Lookup lookup, Binder source2) {
        this.start = source2.start;
        this.types.addAll(source2.types);
        this.transforms.addAll(source2.transforms);
        this.lookup = lookup;
    }

    public Binder(Binder source2, Transform transform) {
        this.start = source2.start;
        this.types.addAll(source2.types);
        this.transforms.addAll(source2.transforms);
        this.add(transform);
        this.lookup = source2.lookup;
    }

    public Binder(Binder source2, Transform transform, MethodType type2) {
        this.start = source2.start;
        this.types.addAll(source2.types);
        this.transforms.addAll(source2.transforms);
        this.add(transform, type2);
        this.lookup = source2.lookup;
    }

    public static Binder from(MethodType start2) {
        return new Binder(start2);
    }

    public static Binder from(MethodHandles.Lookup lookup, MethodType start2) {
        return new Binder(lookup, start2);
    }

    public static Binder from(Class returnType) {
        return Binder.from(MethodType.methodType(returnType));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class returnType) {
        return Binder.from(lookup, MethodType.methodType(returnType));
    }

    public static Binder from(Class returnType, Class[] argTypes) {
        return Binder.from(MethodType.methodType(returnType, argTypes));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class returnType, Class[] argTypes) {
        return Binder.from(lookup, MethodType.methodType(returnType, argTypes));
    }

    public static Binder from(Class returnType, Class argType0, Class ... argTypes) {
        return Binder.from(MethodType.methodType(returnType, argType0, argTypes));
    }

    public static Binder from(MethodHandles.Lookup lookup, Class returnType, Class argType0, Class ... argTypes) {
        return Binder.from(lookup, MethodType.methodType(returnType, argType0, argTypes));
    }

    public static Binder from(Binder start2) {
        return new Binder(start2);
    }

    public static Binder from(MethodHandles.Lookup lookup, Binder start2) {
        return new Binder(lookup, start2);
    }

    public Binder to(Binder other) {
        assert (this.type().equals((Object)other.start));
        Binder newBinder = new Binder(this);
        ListIterator<Transform> iter = other.transforms.listIterator(other.transforms.size());
        while (iter.hasPrevious()) {
            Transform t = iter.previous();
            newBinder.add(t);
        }
        return newBinder;
    }

    public Binder withLookup(MethodHandles.Lookup lookup) {
        return Binder.from(lookup, this);
    }

    private void add(Transform transform) {
        this.add(transform, transform.down(this.types.get(0)));
    }

    private void add(Transform transform, MethodType target) {
        this.types.add(0, target);
        this.transforms.add(0, transform);
    }

    public MethodType type() {
        return this.types.get(0);
    }

    public Binder printType(PrintStream ps) {
        ps.println(this.types.get(0));
        return this;
    }

    public Binder printType() {
        return this.printType(System.out);
    }

    public Binder logType() {
        this.logger.info(this.types.get(0).toString());
        return this;
    }

    public Binder insert(int index2, boolean value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, byte value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, short value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, char value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, int value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, long value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, float value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, double value2) {
        return new Binder(this, new Insert(index2, value2));
    }

    public Binder insert(int index2, Object ... values2) {
        return new Binder(this, new Insert(index2, values2));
    }

    public Binder insert(int index2, Class[] types, Object ... values2) {
        return new Binder(this, new Insert(index2, types, values2));
    }

    public Binder append(boolean value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(byte value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(short value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(char value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(int value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(long value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(float value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(double value2) {
        return new Binder(this, new Insert(this.type().parameterCount(), value2));
    }

    public Binder append(Object ... values2) {
        return new Binder(this, new Insert(this.type().parameterCount(), values2));
    }

    public Binder prepend(boolean value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(byte value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(short value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(char value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(int value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(long value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(float value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(double value2) {
        return new Binder(this, new Insert(0, value2));
    }

    public Binder prepend(Object ... values2) {
        return new Binder(this, new Insert(0, values2));
    }

    public Binder append(Class[] types, Object ... values2) {
        return new Binder(this, new Insert(this.type().parameterCount(), types, values2));
    }

    public Binder drop(int index2) {
        return this.drop(index2, 1);
    }

    public Binder drop(int index2, int count2) {
        return new Binder(this, new Drop(index2, Arrays.copyOfRange(this.type().parameterArray(), index2, index2 + count2)));
    }

    public Binder dropLast() {
        return this.dropLast(1);
    }

    public Binder dropLast(int count2) {
        assert (count2 <= this.type().parameterCount());
        return this.drop(this.type().parameterCount() - count2, count2);
    }

    public Binder convert(MethodType target) {
        return new Binder(this, new Convert(this.type()), target);
    }

    public Binder convert(Class returnType, Class ... argTypes) {
        return new Binder(this, new Convert(this.type()), MethodType.methodType(returnType, argTypes));
    }

    public Binder cast(MethodType type2) {
        return new Binder(this, new Cast(this.type()), type2);
    }

    public Binder cast(Class returnType, Class ... argTypes) {
        return new Binder(this, new Cast(this.type()), MethodType.methodType(returnType, argTypes));
    }

    public Binder spread(Class ... spreadTypes) {
        if (spreadTypes.length == 0) {
            return this.dropLast();
        }
        return new Binder(this, new Spread(this.type(), spreadTypes));
    }

    public Binder spread(int count2) {
        if (count2 == 0) {
            return this.dropLast();
        }
        TypeDescriptor.OfField aryType = this.type().parameterType(this.type().parameterCount() - 1);
        assert (((Class)aryType).isArray());
        Object[] spreadTypes = new Class[count2];
        Arrays.fill(spreadTypes, ((Class)aryType).getComponentType());
        return this.spread((Class[])spreadTypes);
    }

    public Binder collect(int index2, Class type2) {
        return new Binder(this, new Collect(this.type(), index2, type2));
    }

    public Binder varargs(int index2, Class type2) {
        return new Binder(this, new Varargs(this.type(), index2, type2));
    }

    public Binder permute(int ... reorder) {
        return new Binder(this, new Permute(this.type(), reorder));
    }

    public Binder fold(MethodHandle function) {
        return new Binder(this, new Fold(function));
    }

    public Binder foldVoid(MethodHandle function) {
        if (this.type().returnType() == Void.TYPE) {
            return this.fold(function);
        }
        return this.fold(function.asType(function.type().changeReturnType(Void.TYPE)));
    }

    public Binder foldStatic(MethodHandles.Lookup lookup, Class target, String method2) {
        return this.fold(Binder.from(this.type()).invokeStaticQuiet(lookup, target, method2));
    }

    public Binder foldStatic(Class target, String method2) {
        return this.foldStatic(this.lookup, target, method2);
    }

    public Binder foldVirtual(MethodHandles.Lookup lookup, String method2) {
        return this.fold(Binder.from(this.type()).printType().invokeVirtualQuiet(lookup, method2));
    }

    public Binder foldVirtual(String method2) {
        return this.foldVirtual(this.lookup, method2);
    }

    public Binder filter(int index2, MethodHandle ... functions) {
        return new Binder(this, new Filter(index2, functions));
    }

    public Binder filterReturn(MethodHandle function) {
        return new Binder(this, new FilterReturn(function));
    }

    public Binder tryFinally(MethodHandle post) {
        return new Binder(this, new TryFinally(post));
    }

    public Binder catchException(Class<? extends Throwable> throwable, MethodHandle function) {
        return new Binder(this, new Catch(throwable, function));
    }

    public MethodHandle nop() {
        if (this.type().returnType() != Void.TYPE) {
            throw new InvalidTransformException("must have void return type to nop: " + this.type());
        }
        return this.invoke(Binder.from(this.type()).drop(0, this.type().parameterCount()).cast(Object.class, new Class[0]).constant(null));
    }

    public MethodHandle throwException() {
        if (this.type().parameterCount() != 1 || !Throwable.class.isAssignableFrom((Class<?>)this.type().parameterType(0))) {
            throw new InvalidTransformException("incoming signature must have one Throwable type as its sole argument: " + this.type());
        }
        return this.invoke(MethodHandles.throwException(this.type().returnType(), (Class<? extends Throwable>)this.type().parameterType(0)));
    }

    public MethodHandle constant(Object value2) {
        return this.invoke(MethodHandles.constant(this.type().returnType(), value2));
    }

    public MethodHandle identity() {
        return this.invoke(MethodHandles.identity(this.type().parameterType(0)));
    }

    public MethodHandle invoke(MethodHandle target) {
        MethodHandle current2 = target;
        for (Transform t : this.transforms) {
            current2 = t.up(current2);
        }
        current2 = MethodHandles.explicitCastArguments(current2, this.start);
        return current2;
    }

    public MethodHandle invoke(MethodHandles.Lookup lookup, Method method2) throws IllegalAccessException {
        return this.invoke(lookup.unreflect(method2));
    }

    public MethodHandle invokeQuiet(MethodHandles.Lookup lookup, Method method2) {
        try {
            return this.invoke(lookup, method2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
    }

    public MethodHandle invokeStatic(MethodHandles.Lookup lookup, Class target, String name2) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findStatic(target, name2, this.type()));
    }

    public MethodHandle invokeStaticQuiet(MethodHandles.Lookup lookup, Class target, String name2) {
        try {
            return this.invokeStatic(lookup, target, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidTransformException(nsme);
        }
    }

    public MethodHandle invokeVirtual(MethodHandles.Lookup lookup, String name2) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findVirtual((Class<?>)this.type().parameterType(0), name2, this.type().dropParameterTypes(0, 1)));
    }

    public MethodHandle invokeVirtualQuiet(MethodHandles.Lookup lookup, String name2) {
        try {
            return this.invokeVirtual(lookup, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidTransformException(nsme);
        }
    }

    public MethodHandle invokeSpecial(MethodHandles.Lookup lookup, String name2, Class caller2) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findSpecial((Class<?>)this.type().parameterType(0), name2, this.type().dropParameterTypes(0, 1), caller2));
    }

    public MethodHandle invokeSpecialQuiet(MethodHandles.Lookup lookup, String name2, Class caller2) {
        try {
            return this.invokeSpecial(lookup, name2, caller2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidTransformException(nsme);
        }
    }

    public MethodHandle invokeConstructor(MethodHandles.Lookup lookup, Class target) throws NoSuchMethodException, IllegalAccessException {
        return this.invoke(lookup.findConstructor(target, this.type().changeReturnType(Void.TYPE)));
    }

    public MethodHandle invokeConstructorQuiet(MethodHandles.Lookup lookup, Class target) {
        try {
            return this.invokeConstructor(lookup, target);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchMethodException nsme) {
            throw new InvalidTransformException(nsme);
        }
    }

    public MethodHandle getField(MethodHandles.Lookup lookup, String name2) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findGetter((Class<?>)this.type().parameterType(0), name2, (Class<?>)this.type().returnType()));
    }

    public MethodHandle getFieldQuiet(MethodHandles.Lookup lookup, String name2) {
        try {
            return this.getField(lookup, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new InvalidTransformException(nsfe);
        }
    }

    public MethodHandle getStatic(MethodHandles.Lookup lookup, Class target, String name2) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findStaticGetter(target, name2, (Class<?>)this.type().returnType()));
    }

    public MethodHandle getStaticQuiet(MethodHandles.Lookup lookup, Class target, String name2) {
        try {
            return this.getStatic(lookup, target, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new InvalidTransformException(nsfe);
        }
    }

    public MethodHandle setField(MethodHandles.Lookup lookup, String name2) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findSetter((Class<?>)this.type().parameterType(0), name2, (Class<?>)this.type().parameterType(1)));
    }

    public MethodHandle setFieldQuiet(MethodHandles.Lookup lookup, String name2) {
        try {
            return this.setField(lookup, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new InvalidTransformException(nsfe);
        }
    }

    public MethodHandle setStatic(MethodHandles.Lookup lookup, Class target, String name2) throws NoSuchFieldException, IllegalAccessException {
        return this.invoke(lookup.findStaticSetter(target, name2, (Class<?>)this.type().parameterType(0)));
    }

    public MethodHandle setStaticQuiet(MethodHandles.Lookup lookup, Class target, String name2) {
        try {
            return this.setStatic(lookup, target, name2);
        }
        catch (IllegalAccessException iae) {
            throw new InvalidTransformException(iae);
        }
        catch (NoSuchFieldException nsfe) {
            throw new InvalidTransformException(nsfe);
        }
    }

    public MethodHandle arraySet() {
        return this.invoke(MethodHandles.arrayElementSetter(this.type().parameterType(0)));
    }

    public MethodHandle arrayGet() {
        return this.invoke(MethodHandles.arrayElementGetter(this.type().parameterType(0)));
    }

    public MethodHandle branch(MethodHandle test2, MethodHandle truePath, MethodHandle falsePath) {
        return this.invoke(MethodHandles.guardWithTest(test2, truePath, falsePath));
    }

    public MethodHandle invoker() {
        return this.invoke(MethodHandles.invoker(this.start));
    }
}

