/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import org.jruby.ast.ArgsNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ir.IRBuilder19;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.ruby20.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ruby20.ReceiveKeywordRestArgInstr;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.UndefinedValue;

public class IRBuilder20
extends IRBuilder19 {
    public IRBuilder20(IRManager manager) {
        super(manager);
    }

    @Override
    public boolean is1_9() {
        return false;
    }

    @Override
    public boolean is2_0() {
        return true;
    }

    @Override
    public void receiveArgs(ArgsNode argsNode, IRScope s2) {
        KeywordRestArgNode keyRest;
        this.receiveNonBlockArgs(argsNode, s2);
        ListNode keywords = argsNode.getKeywords();
        int required = argsNode.getRequiredArgsCount();
        if (keywords != null) {
            for (Node knode : keywords.childNodes()) {
                KeywordArgNode kwarg = (KeywordArgNode)knode;
                AssignableNode kasgn = kwarg.getAssignable();
                String argName = ((INameNode)((Object)kasgn)).getName();
                LocalVariable av = s2.getNewLocalVariable(argName, 0);
                Label l = s2.getNewLabel();
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc("kwarg", argName);
                }
                s2.addInstr(new ReceiveKeywordArgInstr(av, required));
                s2.addInstr(BNEInstr.create(av, UndefinedValue.UNDEFINED, l));
                this.build(kasgn, s2);
                s2.addInstr(new LabelInstr(l));
            }
        }
        if ((keyRest = argsNode.getKeyRest()) != null) {
            String argName = keyRest.getName();
            LocalVariable av = s2.getNewLocalVariable(argName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("kwrestarg", argName);
            }
            s2.addInstr(new ReceiveKeywordRestArgInstr(av, required));
        }
        this.receiveBlockArg(argsNode, s2);
    }
}

