/*
 * Decompiled with CFR 0.152.
 */
package jnr.unixsocket;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channel;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.enxio.channels.NativeSocketChannel;
import jnr.ffi.byref.IntByReference;
import jnr.unixsocket.Native;

public class UnixSocket {
    private final NativeSocketChannel channel;

    UnixSocket(NativeSocketChannel channel) {
        this.channel = channel;
    }

    public final Channel getChannel() {
        return this.channel;
    }

    public final void setKeepAlive(boolean on) {
        Native.setsockopt(this.channel.getFD(), SocketLevel.SOL_SOCKET, SocketOption.SO_KEEPALIVE, on);
    }

    public final boolean getKeepAlive() {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        IntByReference ref = new IntByReference(4);
        Native.libsocket().getsockopt(this.channel.getFD(), SocketLevel.SOL_SOCKET.intValue(), SocketOption.SO_KEEPALIVE.intValue(), buf, ref);
        return buf.getInt(0) != 0;
    }
}

