/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxEventDispatcher;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReduxCommandBlockTileEntity
extends TileEntity {
    private String packId = "";
    private Object[] lastEventArgs;
    protected volatile Block reduxBlock = null;
    protected int lastSuccessCount = 0;
    protected CommandResultStats.Type lastResultType = CommandResultStats.Type.SUCCESS_COUNT;
    protected int lastResultAmount = 0;
    protected final Set<ReduxBlockEventReceiver> eventReceivers = new HashSet<ReduxBlockEventReceiver>();
    protected final Map<Trigger.TriggerEvent, Set<ReduxBlockEventReceiver>> specialReceivers = new HashMap<Trigger.TriggerEvent, Set<ReduxBlockEventReceiver>>();
    protected final Map<String, String> reduxVariables = new HashMap<String, String>();
    protected final Stack<Integer> commandResultStack = new Stack();

    public int getLastSuccessCount() {
        return this.lastSuccessCount;
    }

    public void addSpecialEventReceiver(Trigger.TriggerEvent event, ReduxBlockEventReceiver receiver) {
        if (!this.specialReceivers.containsKey((Object)event)) {
            this.specialReceivers.put(event, new HashSet());
        }
        this.specialReceivers.get((Object)event).add(receiver);
    }

    public void init(String packId, Block reduxBlock) {
        this.packId = packId;
        this.reduxBlock = reduxBlock;
        this.setupTriggers();
    }

    public void setupTileEntity(String blockId) {
        Pack p = Redux.instance.getReduxConfiguration().getPackFromId(this.packId);
        if (p == null) {
            throw new AssertionError();
        }
        this.reduxBlock = p.getBlockFromId(blockId);
        if (this.reduxBlock == null) {
            throw new AssertionError();
        }
        this.specialReceivers.clear();
        this.eventReceivers.clear();
        this.setupTriggers();
    }

    private void setupTriggers() {
        for (Trigger trigger : this.reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            if (trigger.getTriggerEvent().getForgeEventClass() != Event.class) {
                this.eventReceivers.add(receiver);
                ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
                continue;
            }
            this.addSpecialEventReceiver(trigger.getTriggerEvent(), receiver);
        }
    }

    public boolean triggerSpecialEvent(Trigger.TriggerEvent event, Object ... args) {
        if (this.specialReceivers.containsKey((Object)event)) {
            this.lastEventArgs = args;
            for (ReduxBlockEventReceiver eventReceiver : this.specialReceivers.get((Object)event)) {
                eventReceiver.receiveEvent(null);
            }
            return true;
        }
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("lastSuccessCount", this.lastSuccessCount);
        compound.func_74768_a(this.lastResultType.func_179637_b(), this.lastResultAmount);
        compound.func_74778_a("pack", this.packId);
        compound.func_74778_a("block", this.reduxBlock.getId());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lastSuccessCount = compound.func_74762_e("lastSuccessCount");
        this.packId = compound.func_74779_i("pack");
        this.setupTileEntity(compound.func_74779_i("block"));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    protected static boolean isNumeric(String str) {
        NumberFormat formatter = NumberFormat.getInstance();
        ParsePosition pos = new ParsePosition(0);
        formatter.parse(str, pos);
        return str.length() == pos.getIndex();
    }

    protected class ReduxBlockEventReceiver
    implements ICommandSender {
        private final Trigger triggerScript;
        protected Event lastEvent = null;

        public ReduxBlockEventReceiver(Trigger triggerScript) {
            this.triggerScript = triggerScript;
        }

        public Trigger getTriggerScript() {
            return this.triggerScript;
        }

        public Event getLastEvent() {
            return this.lastEvent;
        }

        public String func_70005_c_() {
            return ReduxCommandBlockTileEntity.this.reduxBlock.getId();
        }

        public IChatComponent func_145748_c_() {
            return new ChatComponentText(ReduxCommandBlockTileEntity.this.reduxBlock.getName());
        }

        public void func_145747_a(IChatComponent message) {
            ReduxCommandBlockTileEntity.this.reduxVariables.put("msg", message.func_150261_e());
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos func_180425_c() {
            return ReduxCommandBlockTileEntity.this.func_174877_v();
        }

        public Vec3 func_174791_d() {
            return new Vec3((double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177958_n() + 0.5, (double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177956_o() + 0.5, (double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177952_p() + 0.5);
        }

        public World func_130014_f_() {
            return ReduxCommandBlockTileEntity.this.func_145831_w();
        }

        public Entity func_174793_f() {
            return null;
        }

        public boolean func_174792_t_() {
            return false;
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
            ReduxCommandBlockTileEntity.this.lastResultType = type;
            ReduxCommandBlockTileEntity.this.lastResultAmount = amount;
            if (type == CommandResultStats.Type.SUCCESS_COUNT) {
                ReduxCommandBlockTileEntity.this.commandResultStack.push(amount);
                IBlockState defaultState = ReduxCommandBlockTileEntity.this.func_145831_w().func_180495_p(ReduxCommandBlockTileEntity.this.field_174879_c).func_177230_c().func_176223_P();
                ReduxCommandBlockTileEntity.this.func_145831_w().func_175656_a(ReduxCommandBlockTileEntity.this.field_174879_c, defaultState.func_177226_a((IProperty)ReduxBlock.SUCCESS_COUNT_META, (Comparable)Integer.valueOf(amount)));
                ReduxCommandBlockTileEntity.this.lastSuccessCount = amount;
            }
        }

        public void setLastTest(int result) {
            ReduxCommandBlockTileEntity.this.reduxVariables.put("test", String.valueOf(result));
        }

        public void receiveEvent(Event event) {
            if (((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).field_145850_b.field_72995_K) {
                return;
            }
            ReduxCommandBlockTileEntity.this.commandResultStack.clear();
            BlockPos blockPos = ReduxCommandBlockTileEntity.this.field_174879_c;
            if (ReduxCommandBlockTileEntity.this.func_145831_w().func_180495_p(ReduxCommandBlockTileEntity.this.field_174879_c).func_177230_c().getClass() != ReduxBlock.class) {
                return;
            }
            EntityPlayerMP playerTrigger = null;
            if (event != null) {
                if (event instanceof ChunkWatchEvent) {
                    ChunkWatchEvent chunkWatchEvent = (ChunkWatchEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(chunkWatchEvent.chunk.field_77276_a));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(chunkWatchEvent.chunk.field_77275_b));
                    playerTrigger = chunkWatchEvent.player;
                } else if (event instanceof BlockEvent) {
                    BlockEvent blockEvent = (BlockEvent)event;
                    if (this.triggerScript.blockHasToBeTheCause() && !blockEvent.pos.equals((Object)ReduxCommandBlockTileEntity.this.field_174879_c)) {
                        return;
                    }
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_x", String.valueOf(blockEvent.pos.func_177958_n()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_y", String.valueOf(blockEvent.pos.func_177956_o()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_z", String.valueOf(blockEvent.pos.func_177952_p()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(blockEvent.world.func_175726_f((BlockPos)blockEvent.pos).func_76632_l().field_77276_a));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(blockEvent.world.func_175726_f((BlockPos)blockEvent.pos).func_76632_l().field_77275_b));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_id", ((BlockEvent)event).state.func_177230_c().func_149739_a());
                    switch (this.triggerScript.getTriggerEvent()) {
                        case BlockBreakEvent: {
                            playerTrigger = ((BlockEvent.BreakEvent)event).getPlayer();
                            break;
                        }
                        case BlockPlaceEvent: 
                        case BlockMultiPlaceEvent: {
                            playerTrigger = ((BlockEvent.PlaceEvent)event).player;
                            break;
                        }
                        case BlockHarvestDropsEvent: {
                            playerTrigger = ((BlockEvent.HarvestDropsEvent)event).harvester;
                        }
                    }
                } else if (event instanceof ServerChatEvent) {
                    ServerChatEvent chatEvent = (ServerChatEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chat_message", chatEvent.message);
                    playerTrigger = chatEvent.player;
                } else if (event instanceof ExplosionEvent) {
                    ExplosionEvent explosionEvent = (ExplosionEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_x", String.valueOf((int)explosionEvent.explosion.getPosition().field_72450_a));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_y", String.valueOf((int)explosionEvent.explosion.getPosition().field_72448_b));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_z", String.valueOf((int)explosionEvent.explosion.getPosition().field_72448_b));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(explosionEvent.world.func_175726_f((BlockPos)new BlockPos((Vec3)explosionEvent.explosion.getPosition())).func_76632_l().field_77276_a));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(explosionEvent.world.func_175726_f((BlockPos)new BlockPos((Vec3)explosionEvent.explosion.getPosition())).func_76632_l().field_77275_b));
                }
                ReduxCommandBlockTileEntity.this.reduxVariables.put("event_name", this.triggerScript.getTriggerEvent().name());
            } else if (event == null && ReduxCommandBlockTileEntity.this.lastEventArgs != null && ReduxCommandBlockTileEntity.this.lastEventArgs.length > 0) {
                if (this.triggerScript.getTriggerEvent() == Trigger.TriggerEvent.OnEntityCollide) {
                    Entity entity = (Entity)ReduxCommandBlockTileEntity.this.lastEventArgs[0];
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("entity_name", entity.func_70005_c_());
                } else if (this.triggerScript.getTriggerEvent() == Trigger.TriggerEvent.OnInteract) {
                    boolean rightClicked = (Boolean)ReduxCommandBlockTileEntity.this.lastEventArgs[0];
                    playerTrigger = (EntityPlayerMP)ReduxCommandBlockTileEntity.this.lastEventArgs[1];
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("mouse_button", rightClicked ? "right" : "left");
                    if (rightClicked) {
                        EnumFacing sideClicked = (EnumFacing)ReduxCommandBlockTileEntity.this.lastEventArgs[2];
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("side_clicked", sideClicked.func_176742_j());
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("hit_x", String.valueOf(ReduxCommandBlockTileEntity.this.lastEventArgs[3]));
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("hit_y", String.valueOf(ReduxCommandBlockTileEntity.this.lastEventArgs[4]));
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("hit_z", String.valueOf(ReduxCommandBlockTileEntity.this.lastEventArgs[5]));
                    }
                } else if (this.triggerScript.getTriggerEvent() == Trigger.TriggerEvent.OnRestoneStrengthChange) {
                    for (int i = 0; i < 7; ++i) {
                        if (i == 7) {
                            ReduxCommandBlockTileEntity.this.reduxVariables.put("weak", String.valueOf(i));
                            continue;
                        }
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("strong:" + EnumFacing.values()[i].func_176742_j(), String.valueOf(i));
                    }
                }
            }
            if (playerTrigger != null) {
                ReduxCommandBlockTileEntity.this.reduxVariables.put("player", playerTrigger.func_70005_c_());
                ReduxCommandBlockTileEntity.this.reduxVariables.put("player_x", String.valueOf(playerTrigger.func_180425_c().func_177958_n()));
                ReduxCommandBlockTileEntity.this.reduxVariables.put("player_y", String.valueOf(playerTrigger.func_180425_c().func_177956_o()));
                ReduxCommandBlockTileEntity.this.reduxVariables.put("player_z", String.valueOf(playerTrigger.func_180425_c().func_177952_p()));
                ReduxCommandBlockTileEntity.this.reduxVariables.put("active_slot", String.valueOf(playerTrigger.field_71071_by.field_70461_c));
                if (playerTrigger.field_71071_by.func_70448_g() != null) {
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("active_item", playerTrigger.field_71071_by.func_70448_g().func_77973_b().delegate.name());
                } else {
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("active_item", "minecraft:hand");
                }
            }
            ReduxCommandBlockTileEntity.this.reduxVariables.put("world_id", String.valueOf(((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).field_145850_b.field_73011_w.func_177502_q()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("world_name", ReduxCommandBlockTileEntity.this.field_145850_b.func_72912_H().func_76065_j());
            ReduxCommandBlockTileEntity.this.reduxVariables.put("x", String.valueOf(blockPos.func_177958_n()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("y", String.valueOf(blockPos.func_177956_o()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("z", String.valueOf(blockPos.func_177952_p()));
            ICommandManager icommandmanager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            this.lastEvent = event;
            int skipCount = 0;
            for (String s : this.triggerScript.getCommands()) {
                String[] split;
                if (skipCount > 0) {
                    --skipCount;
                    continue;
                }
                String parsedCommand = s;
                Pattern reduxPattern = Pattern.compile("\\$redux\\[\\w{1,}\\]");
                Matcher reduxMatcher = reduxPattern.matcher(parsedCommand);
                Pattern commandPattern = Pattern.compile("\\[\\w{1,}\\]");
                while (reduxMatcher.find()) {
                    MatchResult result = reduxMatcher.toMatchResult();
                    Matcher commandMatcher = commandPattern.matcher(result.group());
                    if (!commandMatcher.find()) continue;
                    String command = commandMatcher.toMatchResult().group().replaceFirst("\\[", "").replaceFirst("\\]", "");
                    if (command.equalsIgnoreCase("PEEK") || command.equalsIgnoreCase("POP")) {
                        if (command.equalsIgnoreCase("PEEK")) {
                            parsedCommand = reduxMatcher.replaceFirst(String.valueOf(ReduxCommandBlockTileEntity.this.commandResultStack.peek()));
                            reduxMatcher = reduxPattern.matcher(parsedCommand);
                            continue;
                        }
                        if (!command.equalsIgnoreCase("POP")) continue;
                        parsedCommand = reduxMatcher.replaceFirst(String.valueOf(ReduxCommandBlockTileEntity.this.commandResultStack.pop()));
                        reduxMatcher = reduxPattern.matcher(parsedCommand);
                        continue;
                    }
                    if (!ReduxCommandBlockTileEntity.this.reduxVariables.containsKey(command)) continue;
                    parsedCommand = reduxMatcher.replaceFirst(ReduxCommandBlockTileEntity.this.reduxVariables.get(command));
                    reduxMatcher = reduxPattern.matcher(parsedCommand);
                }
                if (parsedCommand.startsWith("/stopscript")) {
                    boolean stopScript;
                    split = parsedCommand.split(" ");
                    if (split.length != 2 || !(stopScript = ReduxCommandBlockTileEntity.isNumeric(split[1]) ? Integer.parseInt(split[1]) != 0 : split[1].equalsIgnoreCase("true"))) continue;
                    break;
                }
                if (parsedCommand.startsWith("/stopdefault")) {
                    split = parsedCommand.split(" ");
                    if (split.length != 2) continue;
                    boolean stopEvent = ReduxCommandBlockTileEntity.isNumeric(split[1]) ? Integer.parseInt(split[1]) != 0 : split[1].equalsIgnoreCase("true");
                    if (event == null || !event.isCancelable()) continue;
                    event.setCanceled(stopEvent);
                    continue;
                }
                if (parsedCommand.startsWith("/skip")) {
                    split = parsedCommand.split(" ");
                    if (split.length != 3) continue;
                    try {
                        int skip = Integer.parseInt(split[1]);
                        boolean test = ReduxCommandBlockTileEntity.isNumeric(split[2]) ? Integer.parseInt(split[2]) != 0 : split[2].equalsIgnoreCase("true");
                        if (!test || skip <= 0) continue;
                        skipCount = skip;
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                icommandmanager.func_71556_a((ICommandSender)this, parsedCommand);
            }
        }
    }
}

