/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json.model;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mods.quiddity.redux.json.model.Flags;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class Block {
    @Nullable
    protected String extendsBlock;
    private transient Block reduxExtendsBlock = null;
    @Nonnull
    protected String id;
    @Nonnull
    protected String name;
    @Nonnull
    protected String material;
    @Nullable
    protected String description;
    @Nullable
    protected boolean full_cube = true;
    @Nullable
    protected boolean is_weak;
    @Nullable
    protected List<CollisionBox> collisionBoxes;
    @Nullable
    protected boolean directional;
    @Nullable
    protected List<Flags<String, Integer>> custom_properties;
    @Nullable
    protected List<String> ignored_properties;
    @Nullable
    protected String redstone_output_property;
    @Nullable
    protected String creative_tab;
    @Nullable
    protected String creative_tab_icon;
    @Nullable
    protected int tick_rate = -1;
    @Nullable
    protected List<String> ore_dictionary;
    @Nullable
    protected List<Trigger> script;
    private transient CreativeTabs creativeTabObject = null;

    public String getExtendsBlock() {
        return this.extendsBlock;
    }

    public Block getReduxExtendsBlock() {
        return this.reduxExtendsBlock;
    }

    public void setReduxExtendsBlock(Block reduxExtendsBlock) {
        this.reduxExtendsBlock = reduxExtendsBlock;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? (this.reduxExtendsBlock == null ? "" : this.reduxExtendsBlock.getDescription()) : this.description;
    }

    public String getId() {
        return this.id;
    }

    public int getTickRate() {
        return this.tick_rate == -1 ? (this.reduxExtendsBlock == null ? 0 : this.reduxExtendsBlock.getTickRate()) : this.tick_rate;
    }

    public boolean tickable() {
        return this.getTickRate() > 0;
    }

    public Material getMaterial() {
        if (this.material == null && this.reduxExtendsBlock != null) {
            return this.reduxExtendsBlock.getMaterial();
        }
        try {
            return (Material)Material.class.getField(this.material).get(null);
        }
        catch (Exception e) {
            return Material.field_151579_a;
        }
    }

    public boolean shouldAddFacingProperty() {
        return this.directional;
    }

    public List<CollisionBox> getCollisionBoxes() {
        if (this.collisionBoxes != null) {
            return ImmutableList.copyOf(this.collisionBoxes);
        }
        if (this.reduxExtendsBlock != null) {
            return this.reduxExtendsBlock.getCollisionBoxes();
        }
        return null;
    }

    public boolean hasMultipleCollisionBoxes() {
        return this.getCollisionBoxes() != null && this.getCollisionBoxes().size() > 1;
    }

    public boolean isFullCube() {
        return this.full_cube;
    }

    public boolean isWeak() {
        return this.is_weak;
    }

    public CreativeTabs getCreativeTab() {
        if (this.creative_tab == null || this.creative_tab.isEmpty()) {
            if (this.reduxExtendsBlock != null && this.reduxExtendsBlock.getCreativeTab() != CreativeTabs.field_78027_g) {
                return this.reduxExtendsBlock.getCreativeTab();
            }
            this.creativeTabObject = CreativeTabs.field_78027_g;
            return this.creativeTabObject;
        }
        if (this.creativeTabObject == null) {
            for (CreativeTabs tab : CreativeTabs.field_78032_a) {
                if (!tab.func_78013_b().equalsIgnoreCase(this.creative_tab)) continue;
                this.creativeTabObject = tab;
            }
            if (this.creativeTabObject == null) {
                this.creativeTabObject = new CreativeTabs(this.creative_tab){

                    public Item func_78016_d() {
                        return Block.this.creative_tab_icon == null || Block.this.creative_tab_icon.isEmpty() || Item.func_111206_d((String)Block.this.creative_tab_icon) == null ? (Block.this.reduxExtendsBlock == null ? ItemBlock.func_150898_a((net.minecraft.block.Block)Blocks.field_150350_a) : (((Block)Block.this).reduxExtendsBlock.creative_tab_icon == null ? ItemBlock.func_150898_a((net.minecraft.block.Block)Blocks.field_150350_a) : Item.func_111206_d((String)((Block)Block.this).reduxExtendsBlock.creative_tab_icon))) : Item.func_111206_d((String)Block.this.creative_tab_icon);
                    }
                };
            }
        }
        return this.creativeTabObject;
    }

    public List<Trigger> getScript() {
        if (this.script == null && this.reduxExtendsBlock != null && this.reduxExtendsBlock.getScript() != null) {
            return this.reduxExtendsBlock.getScript();
        }
        if (this.script == null) {
            return null;
        }
        return ImmutableList.copyOf(this.script);
    }

    public List<String> getOreDictionaryNames() {
        if (this.ore_dictionary == null && this.reduxExtendsBlock != null && this.reduxExtendsBlock.getOreDictionaryNames() != null) {
            return this.reduxExtendsBlock.getOreDictionaryNames();
        }
        if (this.ore_dictionary == null) {
            return null;
        }
        return ImmutableList.copyOf(this.ore_dictionary);
    }

    public List<Flags<String, Integer>> getCustomProperties() {
        if (this.custom_properties == null && this.reduxExtendsBlock != null && this.reduxExtendsBlock.getCustomProperties() != null) {
            return this.reduxExtendsBlock.getCustomProperties();
        }
        if (this.custom_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.custom_properties);
    }

    public List<String> getIgnoredProperties() {
        if (this.ignored_properties == null && this.reduxExtendsBlock != null && this.reduxExtendsBlock.getIgnoredProperties() != null) {
            return this.reduxExtendsBlock.getIgnoredProperties();
        }
        if (this.ignored_properties == null) {
            return null;
        }
        return ImmutableList.copyOf(this.ignored_properties);
    }

    public String getRedstoneOutputProperty() {
        return this.redstone_output_property == null ? (this.reduxExtendsBlock == null ? "" : this.reduxExtendsBlock.getRedstoneOutputProperty()) : this.redstone_output_property;
    }

    public String toString() {
        return this.id + " - " + this.description;
    }

    public class CollisionBox {
        private float minX;
        private float minY;
        private float minZ;
        private float maxX;
        private float maxY;
        private float maxZ;

        public float getMinX() {
            return this.minX;
        }

        public float getMinY() {
            return this.minY;
        }

        public float getMinZ() {
            return this.minZ;
        }

        public float getMaxX() {
            return this.maxX;
        }

        public float getMaxY() {
            return this.maxY;
        }

        public float getMaxZ() {
            return this.maxZ;
        }
    }
}

