/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux.json;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Config;
import mods.quiddity.redux.json.model.Pack;

public class JSONSingleton {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Pack.class, (Object)new BlockDeserializer()).create();
    private static final Charset charset = Charsets.UTF_8;
    private static final File configJSON = new File(Redux.reduxFolder, File.separator + "config.json");
    private static JSONSingleton ourInstance = new JSONSingleton();

    public static JSONSingleton getInstance() {
        return ourInstance;
    }

    private JSONSingleton() {
        try {
            if (!configJSON.exists()) {
                Redux.copyResource("mods/quiddity/redux/json/model/config.json", configJSON);
            }
        }
        catch (IOException e) {
            Redux.instance.getLogger().fatal("Redux: Error copying default Redux configuration!\nRedux will now cause a crash.", new Object[]{true});
            throw new AssertionError();
        }
    }

    public Config loadConfig() throws JSONLoadException {
        return (Config)this.loadJSON(configJSON, Config.class);
    }

    public Object loadJSON(File file, Class<?> clazz) throws JSONLoadException {
        try {
            String json = Files.toString((File)file, (Charset)charset);
            return gson.fromJson(json, clazz);
        }
        catch (IOException e) {
            throw new JSONLoadException(e, "Error loading the JSON file: %s", file.getAbsolutePath());
        }
    }

    public Object loadJSON(Reader input, Class<?> clazz) {
        return gson.fromJson(input, clazz);
    }

    private static class BlockDeserializer
    implements JsonDeserializer<Pack> {
        private static final Gson normalGson = new Gson();

        private BlockDeserializer() {
        }

        public Pack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            Pack pack = (Pack)normalGson.fromJson(json, typeOfT);
            File packSource = Redux.instance.getReduxConfiguration().getSourceForPack(pack);
            JsonElement blockList = json.getAsJsonObject().get("block_list");
            if (blockList.isJsonArray()) {
                JsonArray blockFiles = blockList.getAsJsonArray();
                ArrayList<Block> blocks = new ArrayList<Block>();
                for (JsonElement jsonElement : blockFiles) {
                    if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
                        String filename = jsonElement.getAsJsonPrimitive().getAsString();
                        Block block = null;
                        if (packSource.isFile() && packSource.getName().endsWith(".zip")) {
                            try {
                                ZipFile zipFile = new ZipFile(packSource);
                                ZipEntry blockJson = zipFile.getEntry(filename);
                                if (blockJson == null) {
                                    throw new JsonParseException("The requested block json file does not exist in the pack!");
                                }
                                block = (Block)normalGson.fromJson((Reader)new InputStreamReader(zipFile.getInputStream(blockJson)), Block.class);
                            }
                            catch (IOException e) {
                                throw new JsonParseException((Throwable)e);
                            }
                        }
                        if (packSource.getParentFile().isDirectory()) {
                            try {
                                block = (Block)normalGson.fromJson(Files.toString((File)new File(packSource.getParentFile(), filename), (Charset)charset), Block.class);
                            }
                            catch (Exception e) {
                                throw new JsonParseException((Throwable)e);
                            }
                        }
                        if (block != null) {
                            blocks.add(block);
                            continue;
                        }
                        throw new JsonParseException("Unable to load the block json file!");
                    }
                    if (!jsonElement.isJsonObject()) continue;
                    Block block = (Block)context.deserialize(jsonElement, Block.class);
                    blocks.add(block);
                }
                pack.setBlockList(blocks);
            }
            return pack;
        }
    }

    public static final class JSONLoadException
    extends Exception {
        public JSONLoadException(Throwable cause, String format, Object ... args) {
            super(String.format(format, args), cause);
        }
    }
}

