/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxEventDispatcher;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReduxCommandBlockTileEntity
extends TileEntity {
    private String packId = "";
    private Object[] lastEventArgs;
    protected volatile Block reduxBlock = null;
    protected int lastSuccessCount = 0;
    protected CommandResultStats.Type lastResultType = CommandResultStats.Type.SUCCESS_COUNT;
    protected int lastResultAmount = 0;
    protected final Set<ReduxBlockEventReceiver> eventReceivers = new HashSet<ReduxBlockEventReceiver>();
    protected final Map<Trigger.TriggerEvent, Set<ReduxBlockEventReceiver>> specialReceivers = new HashMap<Trigger.TriggerEvent, Set<ReduxBlockEventReceiver>>();
    protected final Map<String, String> reduxVariables = new HashMap<String, String>();

    public int getLastSuccessCount() {
        return this.lastSuccessCount;
    }

    public void addSpecialEventReceiver(Trigger.TriggerEvent event, ReduxBlockEventReceiver receiver) {
        if (!this.specialReceivers.containsKey((Object)event)) {
            this.specialReceivers.put(event, new HashSet());
        }
        this.specialReceivers.get((Object)event).add(receiver);
    }

    public void init(String packId, Block reduxBlock) {
        this.packId = packId;
        this.reduxBlock = reduxBlock;
        this.setupTriggers();
    }

    public void setupTileEntity(String blockId) {
        Pack p = Redux.instance.getReduxConfiguration().getPackFromId(this.packId);
        if (p == null) {
            throw new AssertionError();
        }
        for (Block b : p.getBlocks()) {
            if (!b.getId().equalsIgnoreCase(blockId)) continue;
            this.reduxBlock = b;
        }
        if (this.reduxBlock == null) {
            throw new AssertionError();
        }
        this.specialReceivers.clear();
        this.eventReceivers.clear();
        this.setupTriggers();
    }

    private void setupTriggers() {
        for (Trigger trigger : this.reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            if (trigger.getTriggerEvent().getForgeEventClass() != Event.class) {
                this.eventReceivers.add(receiver);
                ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
                continue;
            }
            this.addSpecialEventReceiver(trigger.getTriggerEvent(), receiver);
        }
    }

    public void triggerSpecialEvent(Trigger.TriggerEvent event, Object ... args) {
        if (this.specialReceivers.containsKey((Object)event)) {
            this.lastEventArgs = args;
            for (ReduxBlockEventReceiver eventReceiver : this.specialReceivers.get((Object)event)) {
                eventReceiver.receiveEvent(null);
            }
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("lastSuccessCount", this.lastSuccessCount);
        compound.setInteger(this.lastResultType.getTypeName(), this.lastResultAmount);
        compound.setString("pack", this.packId);
        compound.setString("block", this.reduxBlock.getId());
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.lastSuccessCount = compound.getInteger("lastSuccessCount");
        this.packId = compound.getString("pack");
        this.setupTileEntity(compound.getString("block"));
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.pos, 0, nbttagcompound);
    }

    protected class ReduxBlockEventReceiver
    implements ICommandSender {
        private final Trigger triggerScript;
        private int successCount;
        protected Event lastEvent = null;

        public ReduxBlockEventReceiver(Trigger triggerScript) {
            this.triggerScript = triggerScript;
        }

        public Trigger getTriggerScript() {
            return this.triggerScript;
        }

        public Event getLastEvent() {
            return this.lastEvent;
        }

        public String getName() {
            return ReduxCommandBlockTileEntity.this.reduxBlock.getId();
        }

        public IChatComponent getDisplayName() {
            return new ChatComponentText(ReduxCommandBlockTileEntity.this.reduxBlock.getName());
        }

        public void addChatMessage(IChatComponent message) {
        }

        public boolean canUseCommand(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos getPosition() {
            return ReduxCommandBlockTileEntity.this.getPos();
        }

        public Vec3 getPositionVector() {
            return new Vec3((double)ReduxCommandBlockTileEntity.this.pos.getX() + 0.5, (double)ReduxCommandBlockTileEntity.this.pos.getY() + 0.5, (double)ReduxCommandBlockTileEntity.this.pos.getZ() + 0.5);
        }

        public World getEntityWorld() {
            return ReduxCommandBlockTileEntity.this.getWorld();
        }

        public Entity getCommandSenderEntity() {
            return null;
        }

        public boolean sendCommandFeedback() {
            return false;
        }

        public void setCommandStat(CommandResultStats.Type type, int amount) {
            ReduxCommandBlockTileEntity.this.lastResultType = type;
            ReduxCommandBlockTileEntity.this.lastResultAmount = amount;
        }

        public void receiveEvent(Event event) {
            if (((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).worldObj.isRemote) {
                return;
            }
            BlockPos blockPos = ReduxCommandBlockTileEntity.this.pos;
            IBlockState defaultState = ReduxCommandBlockTileEntity.this.getWorld().getBlockState(blockPos).getBlock().getDefaultState();
            if (ReduxCommandBlockTileEntity.this.getWorld().getBlockState(ReduxCommandBlockTileEntity.this.pos).getBlock().getClass() != ReduxBlock.class) {
                return;
            }
            if (event != null && Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass()) != null) {
                EntityPlayerMP player = null;
                if (event instanceof ChunkWatchEvent) {
                    ChunkWatchEvent chunkWatchEvent = (ChunkWatchEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(chunkWatchEvent.chunk.chunkXPos));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(chunkWatchEvent.chunk.chunkZPos));
                    player = chunkWatchEvent.player;
                } else if (event instanceof BlockEvent) {
                    BlockEvent blockEvent = (BlockEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_x", String.valueOf(blockEvent.pos.getX()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_y", String.valueOf(blockEvent.pos.getY()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_z", String.valueOf(blockEvent.pos.getZ()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(blockEvent.world.getChunkFromBlockCoords((BlockPos)blockEvent.pos).getChunkCoordIntPair().chunkXPos));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(blockEvent.world.getChunkFromBlockCoords((BlockPos)blockEvent.pos).getChunkCoordIntPair().chunkZPos));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_id", ((BlockEvent)event).state.getBlock().getUnlocalizedName());
                } else if (event instanceof ServerChatEvent) {
                    ServerChatEvent chatEvent = (ServerChatEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chat_message", chatEvent.message);
                    player = chatEvent.player;
                } else if (event instanceof ExplosionEvent) {
                    ExplosionEvent explosionEvent = (ExplosionEvent)event;
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_x", String.valueOf((int)explosionEvent.explosion.getPosition().xCoord));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_y", String.valueOf((int)explosionEvent.explosion.getPosition().yCoord));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("target_z", String.valueOf((int)explosionEvent.explosion.getPosition().yCoord));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_x", String.valueOf(explosionEvent.world.getChunkFromBlockCoords((BlockPos)new BlockPos((Vec3)explosionEvent.explosion.getPosition())).getChunkCoordIntPair().chunkXPos));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("chunk_z", String.valueOf(explosionEvent.world.getChunkFromBlockCoords((BlockPos)new BlockPos((Vec3)explosionEvent.explosion.getPosition())).getChunkCoordIntPair().chunkZPos));
                }
                ReduxCommandBlockTileEntity.this.reduxVariables.put("event_name", Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass()).name());
                if (player != null) {
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("player", player.getName());
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("player_x", String.valueOf(player.getPosition().getX()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("player_y", String.valueOf(player.getPosition().getY()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("player_z", String.valueOf(player.getPosition().getZ()));
                    ReduxCommandBlockTileEntity.this.reduxVariables.put("active_slot", String.valueOf(player.inventory.currentItem));
                    if (player.inventory.getCurrentItem() != null) {
                        ReduxCommandBlockTileEntity.this.reduxVariables.put("active_item", player.inventory.getCurrentItem().getDisplayName());
                    }
                }
            } else if (event == null && ReduxCommandBlockTileEntity.this.lastEventArgs != null && ReduxCommandBlockTileEntity.this.lastEventArgs.length > 0 && this.triggerScript.getTriggerEvent() == Trigger.TriggerEvent.OnEntityCollide) {
                Entity entity = (Entity)ReduxCommandBlockTileEntity.this.lastEventArgs[0];
                ReduxCommandBlockTileEntity.this.reduxVariables.put("entity_name", entity.getName());
            }
            ReduxCommandBlockTileEntity.this.reduxVariables.put("world_id", String.valueOf(((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).worldObj.provider.getDimensionId()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("world_name", ReduxCommandBlockTileEntity.this.worldObj.getWorldInfo().getWorldName());
            ReduxCommandBlockTileEntity.this.reduxVariables.put("x", String.valueOf(blockPos.getX()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("y", String.valueOf(blockPos.getY()));
            ReduxCommandBlockTileEntity.this.reduxVariables.put("z", String.valueOf(blockPos.getZ()));
            ICommandManager icommandmanager = FMLCommonHandler.instance().getMinecraftServerInstance().getCommandManager();
            Stack<Integer> commandResultStack = new Stack<Integer>();
            this.lastEvent = event;
            int skipCount = 0;
            for (String s : this.triggerScript.getCommands()) {
                String[] split;
                while (skipCount > 0) {
                    --skipCount;
                }
                String parsedCommand = s;
                if (parsedCommand.startsWith("/stopscript")) {
                    boolean stopScript;
                    split = parsedCommand.split(" ");
                    if (split.length != 2 || !(stopScript = Boolean.valueOf(split[1]).booleanValue())) continue;
                    break;
                }
                if (parsedCommand.startsWith("/stopdefault")) {
                    split = parsedCommand.split(" ");
                    if (split.length != 2) continue;
                    boolean stopEvent = Boolean.valueOf(split[1]);
                    if (event == null || !event.isCancelable()) continue;
                    event.setCanceled(stopEvent);
                    break;
                }
                if (parsedCommand.startsWith("/skip")) {
                    split = parsedCommand.split(" ");
                    if (split.length != 3) continue;
                    try {
                        int skip = Integer.parseInt(split[1]);
                        if (!Boolean.parseBoolean(split[2]) || skip <= 0) continue;
                        skipCount = skip;
                    }
                    catch (NumberFormatException ignored) {}
                    continue;
                }
                Pattern reduxPattern = Pattern.compile("\\$redux\\[[a-zA-Z]+\\]", 2);
                Matcher reduxMatcher = reduxPattern.matcher(parsedCommand);
                Pattern commandPattern = Pattern.compile("\\[[a-zA-Z]+\\]", 2);
                while (reduxMatcher.find() && !reduxMatcher.hitEnd()) {
                    MatchResult result = reduxMatcher.toMatchResult();
                    Matcher commandMatcher = commandPattern.matcher(result.group());
                    if (!commandMatcher.find()) continue;
                    String command = commandMatcher.toMatchResult().group().replaceAll("\\[", "").replaceAll("\\]", "");
                    if (command.equalsIgnoreCase("PEEK") || command.equalsIgnoreCase("POP")) {
                        if (command.equalsIgnoreCase("PEEK")) {
                            parsedCommand = reduxMatcher.replaceFirst(String.valueOf(commandResultStack.peek()));
                            reduxMatcher = reduxPattern.matcher(parsedCommand);
                            continue;
                        }
                        if (!command.equalsIgnoreCase("POP")) continue;
                        parsedCommand = reduxMatcher.replaceFirst(String.valueOf(commandResultStack.pop()));
                        reduxMatcher = reduxPattern.matcher(parsedCommand);
                        continue;
                    }
                    if (!ReduxCommandBlockTileEntity.this.reduxVariables.containsKey(command)) continue;
                    parsedCommand = reduxMatcher.replaceFirst(ReduxCommandBlockTileEntity.this.reduxVariables.get(command));
                    reduxMatcher = reduxPattern.matcher(parsedCommand);
                }
                this.successCount = icommandmanager.executeCommand((ICommandSender)this, parsedCommand);
                commandResultStack.push(this.successCount);
                ReduxCommandBlockTileEntity.this.getWorld().setBlockState(blockPos, defaultState.withProperty((IProperty)ReduxBlock.SUCCESS_COUNT_META, (Comparable)Integer.valueOf(this.successCount)));
                ReduxCommandBlockTileEntity.this.lastSuccessCount = this.successCount;
            }
        }
    }
}

