/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxCommandBlockTickableTileEntity;
import mods.quiddity.redux.ReduxEventDispatcher;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReduxCommandBlockTileEntity
extends TileEntity {
    private String packId = "";
    protected volatile Block reduxBlock = null;
    protected int lastSuccessCount = 0;
    protected CommandResultStats.Type lastResultType = CommandResultStats.Type.SUCCESS_COUNT;
    protected int lastResultAmount = 0;
    protected final Set<ReduxBlockEventReceiver> tickEventReceivers = new HashSet<ReduxBlockEventReceiver>();
    protected final Set<ReduxBlockEventReceiver> eventReceivers = new HashSet<ReduxBlockEventReceiver>();

    public int getLastSuccessCount() {
        return this.lastSuccessCount;
    }

    public void addTickEventReceiver(ReduxBlockEventReceiver receiver) {
        this.tickEventReceivers.add(receiver);
    }

    public void init(String packId, Block reduxBlock) {
        this.packId = packId;
        this.reduxBlock = reduxBlock;
        for (Trigger trigger : reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            this.eventReceivers.add(receiver);
            ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
        }
    }

    public void setupTileEntity(String blockId) {
        Pack p = Redux.instance.getReduxConfiguration().getPackFromId(this.packId);
        if (p == null) {
            throw new AssertionError();
        }
        for (Block b : p.getBlocks()) {
            if (!b.getId().equalsIgnoreCase(blockId)) continue;
            this.reduxBlock = b;
        }
        if (this.reduxBlock == null) {
            throw new AssertionError();
        }
        this.tickEventReceivers.clear();
        this.eventReceivers.clear();
        for (Trigger trigger : this.reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            this.eventReceivers.add(receiver);
            ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("lastSuccessCount", this.lastSuccessCount);
        compound.func_74768_a(this.lastResultType.func_179637_b(), this.lastResultAmount);
        compound.func_74778_a("pack", this.packId);
        compound.func_74778_a("block", this.reduxBlock.getId());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.lastSuccessCount = compound.func_74762_e("lastSuccessCount");
        this.packId = compound.func_74779_i("pack");
        this.setupTileEntity(compound.func_74779_i("block"));
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    protected class ReduxBlockEventReceiver
    implements ICommandSender {
        private final Trigger triggerScript;
        private int successCount;
        protected Event lastEvent = null;

        public ReduxBlockEventReceiver(Trigger triggerScript) {
            this.triggerScript = triggerScript;
            if (ReduxCommandBlockTileEntity.this instanceof ReduxCommandBlockTickableTileEntity && triggerScript.getTriggerEvent().getForgeEventClass() == Event.class) {
                ReduxCommandBlockTileEntity.this.addTickEventReceiver(this);
            }
        }

        public Trigger getTriggerScript() {
            return this.triggerScript;
        }

        public Event getLastEvent() {
            return this.lastEvent;
        }

        public String func_70005_c_() {
            return ReduxCommandBlockTileEntity.this.reduxBlock.getId();
        }

        public IChatComponent func_145748_c_() {
            return new ChatComponentText(ReduxCommandBlockTileEntity.this.reduxBlock.getName());
        }

        public void func_145747_a(IChatComponent message) {
        }

        public boolean func_70003_b(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos func_180425_c() {
            return ReduxCommandBlockTileEntity.this.func_174877_v();
        }

        public Vec3 func_174791_d() {
            return new Vec3((double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177958_n() + 0.5, (double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177956_o() + 0.5, (double)ReduxCommandBlockTileEntity.this.field_174879_c.func_177952_p() + 0.5);
        }

        public World func_130014_f_() {
            return ReduxCommandBlockTileEntity.this.func_145831_w();
        }

        public Entity func_174793_f() {
            return null;
        }

        public boolean func_174792_t_() {
            return false;
        }

        public void func_174794_a(CommandResultStats.Type type, int amount) {
            ReduxCommandBlockTileEntity.this.lastResultType = type;
            ReduxCommandBlockTileEntity.this.lastResultAmount = amount;
        }

        private String getTriggerStringForEvent(Event event) {
            if (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass()) != null) {
                if (event instanceof WorldEvent) {
                    WorldEvent worldEvent = (WorldEvent)event;
                    return String.valueOf(worldEvent.world.field_73011_w.func_177502_q());
                }
                if (event instanceof ChunkWatchEvent) {
                    ChunkWatchEvent chunkWatchEvent = (ChunkWatchEvent)event;
                    return chunkWatchEvent.player.func_70005_c_();
                }
                switch (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass())) {
                    case BlockBreakEvent: {
                        BlockEvent.BreakEvent breakEvent = (BlockEvent.BreakEvent)event;
                        return breakEvent.getPlayer().func_70005_c_();
                    }
                    case BlockHarvestDropsEvent: {
                        BlockEvent.HarvestDropsEvent harvestDropsEvent = (BlockEvent.HarvestDropsEvent)event;
                        return harvestDropsEvent.harvester.func_70005_c_();
                    }
                    case BlockMultiPlaceEvent: 
                    case BlockPlaceEvent: {
                        BlockEvent.PlaceEvent placeEvent = (BlockEvent.PlaceEvent)event;
                        return placeEvent.player.func_70005_c_();
                    }
                    case ServerChatEvent: {
                        ServerChatEvent serverChatEvent = (ServerChatEvent)event;
                        return serverChatEvent.username;
                    }
                }
                return String.valueOf(ReduxCommandBlockTileEntity.this.func_145831_w().field_73011_w.func_177502_q());
            }
            return "";
        }

        public void receiveEvent(Event event) {
            if (((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).field_145850_b.field_72995_K) {
                return;
            }
            BlockPos blockPos = ReduxCommandBlockTileEntity.this.field_174879_c;
            IBlockState defaultState = ReduxCommandBlockTileEntity.this.func_145831_w().func_180495_p(blockPos).func_177230_c().func_176223_P();
            if (ReduxCommandBlockTileEntity.this.func_145831_w().func_180495_p(ReduxCommandBlockTileEntity.this.field_174879_c).func_177230_c().getClass() != ReduxBlock.class) {
                return;
            }
            ICommandManager icommandmanager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
            Stack<Integer> commandResultStack = new Stack<Integer>();
            this.lastEvent = event;
            for (String s : this.triggerScript.getCommands()) {
                if (s.startsWith("/pop")) {
                    String[] split = s.split(Pattern.quote(" "));
                    int popCount = 1;
                    if (split.length == 2) {
                        try {
                            popCount = Integer.parseInt(split[1]);
                        }
                        catch (NumberFormatException e) {
                            Redux.instance.getLogger().warn("Invalid /pop command issued. Command %s\nPopping once", new Object[]{s});
                        }
                    }
                    while (popCount > 0) {
                        commandResultStack.pop();
                        --popCount;
                    }
                }
                String parsedCommand = s;
                while ((parsedCommand.contains("$(PEEK)") || parsedCommand.contains("$(POP)") || parsedCommand.contains("$(TRIGGER)")) && !commandResultStack.empty()) {
                    if (parsedCommand.contains("$(PEEK)") && (!parsedCommand.contains("$(POP)") || parsedCommand.indexOf("$(PEEK)") < parsedCommand.indexOf("$(POP)"))) {
                        parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(PEEK)"), Matcher.quoteReplacement(String.valueOf(commandResultStack.peek())));
                        continue;
                    }
                    if (parsedCommand.contains("$(POP)")) {
                        parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(POP)"), Matcher.quoteReplacement(String.valueOf(commandResultStack.pop())));
                        continue;
                    }
                    if (!parsedCommand.contains("$(TRIGGER)")) continue;
                    parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(TRIGGER)"), this.getTriggerStringForEvent(event));
                }
                this.successCount = icommandmanager.func_71556_a((ICommandSender)this, parsedCommand);
                commandResultStack.push(this.successCount);
                ReduxCommandBlockTileEntity.this.func_145831_w().func_175656_a(blockPos, defaultState.func_177226_a((IProperty)ReduxBlock.SUCCESS_COUNT_META, (Comparable)Integer.valueOf(this.successCount)));
                ReduxCommandBlockTileEntity.this.lastSuccessCount = this.successCount;
            }
        }
    }
}

