/*
 * Decompiled with CFR 0.152.
 */
package mods.quiddity.redux;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mods.quiddity.redux.Redux;
import mods.quiddity.redux.ReduxBlock;
import mods.quiddity.redux.ReduxCommandBlockTickableTileEntity;
import mods.quiddity.redux.ReduxEventDispatcher;
import mods.quiddity.redux.json.model.Block;
import mods.quiddity.redux.json.model.Pack;
import mods.quiddity.redux.json.model.Trigger;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ReduxCommandBlockTileEntity
extends TileEntity {
    private String packId = "";
    protected volatile Block reduxBlock = null;
    protected int lastSuccessCount = 0;
    protected CommandResultStats.Type lastResultType = CommandResultStats.Type.SUCCESS_COUNT;
    protected int lastResultAmount = 0;
    protected final Set<ReduxBlockEventReceiver> tickEventReceivers = new HashSet<ReduxBlockEventReceiver>();
    protected final Set<ReduxBlockEventReceiver> eventReceivers = new HashSet<ReduxBlockEventReceiver>();

    public int getLastSuccessCount() {
        return this.lastSuccessCount;
    }

    public void addTickEventReceiver(ReduxBlockEventReceiver receiver) {
        this.tickEventReceivers.add(receiver);
    }

    public void init(String packId, Block reduxBlock) {
        this.packId = packId;
        this.reduxBlock = reduxBlock;
        for (Trigger trigger : reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            this.eventReceivers.add(receiver);
            ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
        }
    }

    public void setupTileEntity(String blockId) {
        Pack p = Redux.instance.getReduxConfiguration().getPackFromId(this.packId);
        if (p == null) {
            throw new AssertionError();
        }
        for (Block b : p.getBlocks()) {
            if (!b.getId().equalsIgnoreCase(blockId)) continue;
            this.reduxBlock = b;
        }
        if (this.reduxBlock == null) {
            throw new AssertionError();
        }
        this.tickEventReceivers.clear();
        this.eventReceivers.clear();
        for (Trigger trigger : this.reduxBlock.getScript()) {
            ReduxBlockEventReceiver receiver = new ReduxBlockEventReceiver(trigger);
            this.eventReceivers.add(receiver);
            ReduxEventDispatcher.getInstance().registerEventReceiver(receiver);
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.setInteger("lastSuccessCount", this.lastSuccessCount);
        compound.setInteger(this.lastResultType.getTypeName(), this.lastResultAmount);
        compound.setString("pack", this.packId);
        compound.setString("block", this.reduxBlock.getId());
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.lastSuccessCount = compound.getInteger("lastSuccessCount");
        this.packId = compound.getString("pack");
        this.setupTileEntity(compound.getString("block"));
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.pos, 0, nbttagcompound);
    }

    protected class ReduxBlockEventReceiver
    implements ICommandSender {
        private final Trigger triggerScript;
        private int successCount;
        protected Event lastEvent = null;

        public ReduxBlockEventReceiver(Trigger triggerScript) {
            this.triggerScript = triggerScript;
            if (ReduxCommandBlockTileEntity.this instanceof ReduxCommandBlockTickableTileEntity && triggerScript.getTriggerEvent().getForgeEventClass() == Event.class) {
                ReduxCommandBlockTileEntity.this.addTickEventReceiver(this);
            }
        }

        public Trigger getTriggerScript() {
            return this.triggerScript;
        }

        public Event getLastEvent() {
            return this.lastEvent;
        }

        public String getName() {
            return ReduxCommandBlockTileEntity.this.reduxBlock.getId();
        }

        public IChatComponent getDisplayName() {
            return new ChatComponentText(ReduxCommandBlockTileEntity.this.reduxBlock.getName());
        }

        public void addChatMessage(IChatComponent message) {
        }

        public boolean canUseCommand(int permLevel, String commandName) {
            return permLevel <= 2;
        }

        public BlockPos getPosition() {
            return ReduxCommandBlockTileEntity.this.getPos();
        }

        public Vec3 getPositionVector() {
            return new Vec3((double)ReduxCommandBlockTileEntity.this.pos.getX() + 0.5, (double)ReduxCommandBlockTileEntity.this.pos.getY() + 0.5, (double)ReduxCommandBlockTileEntity.this.pos.getZ() + 0.5);
        }

        public World getEntityWorld() {
            return ReduxCommandBlockTileEntity.this.getWorld();
        }

        public Entity getCommandSenderEntity() {
            return null;
        }

        public boolean sendCommandFeedback() {
            return false;
        }

        public void setCommandStat(CommandResultStats.Type type, int amount) {
            ReduxCommandBlockTileEntity.this.lastResultType = type;
            ReduxCommandBlockTileEntity.this.lastResultAmount = amount;
        }

        private String getTriggerStringForEvent(Event event) {
            if (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass()) != null) {
                if (event instanceof WorldEvent) {
                    WorldEvent worldEvent = (WorldEvent)event;
                    return String.valueOf(worldEvent.world.provider.getDimensionId());
                }
                if (event instanceof ChunkWatchEvent) {
                    ChunkWatchEvent chunkWatchEvent = (ChunkWatchEvent)event;
                    return chunkWatchEvent.player.getName();
                }
                switch (Trigger.TriggerEvent.getTriggerEventFromForgeEvent(event.getClass())) {
                    case BlockBreakEvent: {
                        BlockEvent.BreakEvent breakEvent = (BlockEvent.BreakEvent)event;
                        return breakEvent.getPlayer().getName();
                    }
                    case BlockHarvestDropsEvent: {
                        BlockEvent.HarvestDropsEvent harvestDropsEvent = (BlockEvent.HarvestDropsEvent)event;
                        return harvestDropsEvent.harvester.getName();
                    }
                    case BlockMultiPlaceEvent: 
                    case BlockPlaceEvent: {
                        BlockEvent.PlaceEvent placeEvent = (BlockEvent.PlaceEvent)event;
                        return placeEvent.player.getName();
                    }
                    case ServerChatEvent: {
                        ServerChatEvent serverChatEvent = (ServerChatEvent)event;
                        return serverChatEvent.username;
                    }
                }
                return String.valueOf(ReduxCommandBlockTileEntity.this.getWorld().provider.getDimensionId());
            }
            return "";
        }

        public void receiveEvent(Event event) {
            if (((ReduxCommandBlockTileEntity)ReduxCommandBlockTileEntity.this).worldObj.isRemote) {
                return;
            }
            BlockPos blockPos = ReduxCommandBlockTileEntity.this.pos;
            IBlockState defaultState = ReduxCommandBlockTileEntity.this.getWorld().getBlockState(blockPos).getBlock().getDefaultState();
            if (ReduxCommandBlockTileEntity.this.getWorld().getBlockState(ReduxCommandBlockTileEntity.this.pos).getBlock().getClass() != ReduxBlock.class) {
                return;
            }
            ICommandManager icommandmanager = FMLCommonHandler.instance().getMinecraftServerInstance().getCommandManager();
            Stack<Integer> commandResultStack = new Stack<Integer>();
            this.lastEvent = event;
            for (String s : this.triggerScript.getCommands()) {
                if (s.startsWith("/pop")) {
                    String[] split = s.split(Pattern.quote(" "));
                    int popCount = 1;
                    if (split.length == 2) {
                        try {
                            popCount = Integer.parseInt(split[1]);
                        }
                        catch (NumberFormatException e) {
                            Redux.instance.getLogger().warn("Invalid /pop command issued. Command %s\nPopping once", new Object[]{s});
                        }
                    }
                    while (popCount > 0) {
                        commandResultStack.pop();
                        --popCount;
                    }
                }
                String parsedCommand = s;
                while ((parsedCommand.contains("$(PEEK)") || parsedCommand.contains("$(POP)") || parsedCommand.contains("$(TRIGGER)")) && !commandResultStack.empty()) {
                    if (parsedCommand.contains("$(PEEK)") && (!parsedCommand.contains("$(POP)") || parsedCommand.indexOf("$(PEEK)") < parsedCommand.indexOf("$(POP)"))) {
                        parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(PEEK)"), Matcher.quoteReplacement(String.valueOf(commandResultStack.peek())));
                        continue;
                    }
                    if (parsedCommand.contains("$(POP)")) {
                        parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(POP)"), Matcher.quoteReplacement(String.valueOf(commandResultStack.pop())));
                        continue;
                    }
                    if (!parsedCommand.contains("$(TRIGGER)")) continue;
                    parsedCommand = parsedCommand.replaceFirst(Pattern.quote("$(TRIGGER)"), this.getTriggerStringForEvent(event));
                }
                this.successCount = icommandmanager.executeCommand((ICommandSender)this, parsedCommand);
                commandResultStack.push(this.successCount);
                ReduxCommandBlockTileEntity.this.getWorld().setBlockState(blockPos, defaultState.withProperty((IProperty)ReduxBlock.SUCCESS_COUNT_META, (Comparable)Integer.valueOf(this.successCount)));
                ReduxCommandBlockTileEntity.this.lastSuccessCount = this.successCount;
            }
        }
    }
}

