/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PlacedItem {
    private static final String NBT_ITEM = "Item";
    private static final String NBT_ROTATION = "Rotation";
    private static final String NBT_XOFFSET = "XOffset";
    private static final String NBT_ZOFFSET = "ZOffset";
    private ItemStack is;
    private float rotation;
    private float xOffset;
    private float zOffset;

    public PlacedItem(ItemStack is) {
        this(is, 0.0f);
    }

    public PlacedItem(ItemStack is, float rotation) {
        this(is, rotation, 0.0f, 0.0f);
    }

    public PlacedItem(ItemStack is, float rotation, float xOffset, float zOffset) {
        this.is = is;
        this.rotation = rotation;
        this.xOffset = xOffset;
        this.zOffset = zOffset;
    }

    public ItemStack getItemStack() {
        return ItemStack.func_77944_b((ItemStack)this.is);
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(float newRotation) {
        this.rotation = newRotation;
    }

    public float getXOffset() {
        return this.xOffset;
    }

    public void setXOffset(float newXOffset) {
        this.xOffset = newXOffset;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(float newZOffset) {
        this.zOffset = newZOffset;
    }

    public static PlacedItem readFromNBT(NBTTagCompound nbtRead) {
        NBTTagCompound nbtItem = nbtRead.func_74775_l(NBT_ITEM);
        ItemStack is = ItemStack.func_77949_a((NBTTagCompound)nbtItem);
        float rotation = nbtRead.func_74760_g(NBT_ROTATION);
        float xOffset = nbtRead.func_74760_g(NBT_XOFFSET);
        float zOffset = nbtRead.func_74760_g(NBT_ZOFFSET);
        return new PlacedItem(is, rotation, xOffset, zOffset);
    }

    public NBTTagCompound writeToNBT(String name) {
        NBTTagCompound nbtWrite = new NBTTagCompound(name);
        NBTTagCompound nbtItem = this.is.func_77955_b(new NBTTagCompound(NBT_ITEM));
        nbtWrite.func_74766_a(NBT_ITEM, nbtItem);
        nbtWrite.func_74776_a(NBT_ROTATION, this.rotation);
        nbtWrite.func_74776_a(NBT_XOFFSET, this.xOffset);
        nbtWrite.func_74776_a(NBT_ZOFFSET, this.zOffset);
        return nbtWrite;
    }

    public boolean equals(Object e) {
        if (!(e instanceof PlacedItem)) {
            return false;
        }
        PlacedItem otherItem = (PlacedItem)e;
        if (!ItemStack.func_77989_b((ItemStack)this.is, (ItemStack)otherItem.getItemStack())) {
            return false;
        }
        if (this.rotation != otherItem.getRotation()) {
            return false;
        }
        if (this.xOffset != otherItem.getXOffset()) {
            return false;
        }
        return this.zOffset == otherItem.getZOffset();
    }
}

