/*
 * Decompiled with CFR 0.152.
 */
package dnoved1.immersify.api;

import dnoved1.immersify.api.IRecipe;
import dnoved1.immersify.api.property.Property;
import java.util.ArrayList;

public abstract class AbstractRecipe
implements IRecipe {
    private ArrayList<Property> specifications = new ArrayList();

    public AbstractRecipe() {
    }

    public AbstractRecipe(Property specifications) {
        this.addSpecifications(specifications);
    }

    @Override
    public boolean matches(Property ... properties) {
        boolean[] matches = new boolean[this.specifications.size()];
        boolean[] used = new boolean[properties.length];
        for (int i = 0; i < this.specifications.size(); ++i) {
            for (int j = 0; j < properties.length; ++j) {
                if (matches[i] || used[j] || !properties[j].matches(this.specifications.get(i))) continue;
                matches[i] = true;
                used[j] = true;
            }
        }
        for (boolean match : matches) {
            if (match) continue;
            return false;
        }
        return true;
    }

    public void addSpecifications(Property ... specifications) {
        for (Property specification : specifications) {
            this.specifications.add(specification);
        }
    }

    public boolean removeSpecifications(Property ... specifications) {
        boolean hasRemoved = false;
        for (Property specification : specifications) {
            hasRemoved = hasRemoved || this.specifications.remove(specification);
        }
        return hasRemoved;
    }

    public Property[] getSpecifications() {
        return this.specifications.toArray(new Property[0]);
    }
}

