/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.tech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.natura.Natura;
import mods.natura.blocks.tech.NetherrackFurnaceLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetherrackFurnaceBlock
extends BlockContainer {
    protected Random rand = new Random();
    int side = -1;
    @SideOnly(value=Side.CLIENT)
    public IIcon[] icons;

    public NetherrackFurnaceBlock() {
        super(Material.rock);
    }

    public TileEntity createNewTileEntity(World world, int metadata) {
        return new NetherrackFurnaceLogic();
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return 2;
    }

    public Object getModInstance() {
        return Natura.instance;
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float clickX, float clickY, float clickZ) {
        if (player.isSneaking()) {
            return false;
        }
        Integer integer = this.getGui(world, x, y, z, player);
        if (integer == null || integer == -1) {
            return false;
        }
        if (!world.isRemote) {
            player.openGui(this.getModInstance(), integer.intValue(), world, x, y, z);
        }
        return true;
    }

    public void breakBlock(World par1World, int x, int y, int z, Block blockID, int meta) {
        TileEntity te = par1World.getTileEntity(x, y, z);
        if (te != null && te instanceof NetherrackFurnaceLogic) {
            NetherrackFurnaceLogic logic = (NetherrackFurnaceLogic)te;
            for (int iter = 0; iter < logic.getSizeInventory(); ++iter) {
                ItemStack stack = logic.getStackInSlot(iter);
                if (stack == null) continue;
                float jumpX = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpY = this.rand.nextFloat() * 0.8f + 0.1f;
                float jumpZ = this.rand.nextFloat() * 0.8f + 0.1f;
                while (stack.stackSize > 0) {
                    int itemSize = this.rand.nextInt(21) + 10;
                    if (itemSize > stack.stackSize) {
                        itemSize = stack.stackSize;
                    }
                    stack.stackSize -= itemSize;
                    EntityItem entityitem = new EntityItem(par1World, (double)((float)x + jumpX), (double)((float)y + jumpY), (double)((float)z + jumpZ), new ItemStack(stack.getItem(), itemSize, stack.getItemDamage()));
                    if (stack.hasTagCompound()) {
                        entityitem.getEntityItem().setTagCompound((NBTTagCompound)stack.getTagCompound().copy());
                    }
                    float offset = 0.05f;
                    entityitem.motionX = (float)this.rand.nextGaussian() * offset;
                    entityitem.motionY = (float)this.rand.nextGaussian() * offset + 0.2f;
                    entityitem.motionZ = (float)this.rand.nextGaussian() * offset;
                    par1World.spawnEntityInWorld((Entity)entityitem);
                }
            }
        }
        super.breakBlock(par1World, x, y, z, blockID, meta);
    }

    public int onBlockPlaced(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        this.side = side;
        return meta;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic instanceof NetherrackFurnaceLogic) {
            NetherrackFurnaceLogic direction = (NetherrackFurnaceLogic)logic;
            if (entityliving == null) {
                direction.setDirection(0.0f, 0.0f, null);
            } else {
                direction.setDirection(entityliving.rotationYaw * 4.0f, entityliving.rotationPitch, entityliving);
            }
        }
        if (logic instanceof NetherrackFurnaceLogic) {
            NetherrackFurnaceLogic inv = (NetherrackFurnaceLogic)logic;
            if (stack.hasDisplayName()) {
                inv.setGuiDisplayName(stack.getDisplayName());
            }
        }
    }

    public static boolean isActive(IBlockAccess world, int x, int y, int z) {
        TileEntity logic = world.getTileEntity(x, y, z);
        if (logic instanceof NetherrackFurnaceLogic) {
            return ((NetherrackFurnaceLogic)logic).getActive();
        }
        return false;
    }

    public int damageDropped(int meta) {
        return meta;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.getTileEntity(x, y, z);
        if (te instanceof NetherrackFurnaceLogic) {
            return ((NetherrackFurnaceLogic)te).getActive() ? 15 : 0;
        }
        return this.getLightValue();
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World par1World, int par2, int par3, int par4, int par5) {
        return Container.calcRedstoneFromInventory((IInventory)((IInventory)par1World.getTileEntity(par2, par3, par4)));
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random par5Random) {
        NetherrackFurnaceLogic logic = (NetherrackFurnaceLogic)world.getTileEntity(x, y, z);
        if (logic.getActive()) {
            int direction = logic.getRenderDirection();
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + par5Random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = par5Random.nextFloat() * 0.6f - 0.3f;
            if (direction == 4) {
                world.spawnParticle("smoke", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (direction == 5) {
                world.spawnParticle("smoke", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (direction == 2) {
                world.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (direction == 3) {
                world.spawnParticle("smoke", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
                world.spawnParticle("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextureIndex(int side) {
        if (side == 0 || side == 1) {
            return 3;
        }
        if (side == 3) {
            return 0;
        }
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.getTileEntity(x, y, z);
        int direction = logic instanceof NetherrackFurnaceLogic ? ((NetherrackFurnaceLogic)logic).getRenderDirection() : 0;
        int meta = world.getBlockMetadata(x, y, z) % 8;
        if (meta == 0) {
            if (side == direction) {
                if (((NetherrackFurnaceLogic)logic).getActive()) {
                    return this.icons[1];
                }
                return this.icons[0];
            }
            if (side > 1) {
                return this.icons[2];
            }
            return this.icons[3];
        }
        return this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"nfurnace_off", "nfurnace_on", "nfurnace_side", "nfurnace_top"};
        return textureNames;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + textureNames[i]);
        }
    }
}

