/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mods.natura.client.BerryRender;
import mods.natura.common.NContent;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public class BerryBush
extends BlockLeavesBase
implements IPlantable {
    Random random;
    public IIcon[] fastIcons;
    public IIcon[] fancyIcons;
    public static String[] textureNames = new String[]{"raspberry", "blueberry", "blackberry", "geoberry", "raspberry_ripe", "blueberry_ripe", "blackberry_ripe", "geoberry_ripe"};

    public BerryBush() {
        super(Material.leaves, false);
        this.setTickRandomly(true);
        this.random = new Random();
        this.setHardness(0.3f);
        this.setStepSound(Block.soundTypeGrass);
        this.setBlockName("berrybush");
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.fastIcons = new IIcon[textureNames.length];
        this.fancyIcons = new IIcon[textureNames.length];
        for (int i = 0; i < this.fastIcons.length; ++i) {
            this.fastIcons[i] = iconRegister.registerIcon("natura:" + textureNames[i] + "_fast");
            this.fancyIcons[i] = iconRegister.registerIcon("natura:" + textureNames[i] + "_fancy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        if (this.field_150121_P) {
            if (metadata < 12) {
                return this.fancyIcons[metadata % 4];
            }
            return this.fancyIcons[metadata % 4 + 4];
        }
        if (metadata < 12) {
            return this.fastIcons[metadata % 4];
        }
        return this.fastIcons[metadata % 4 + 4];
    }

    public int damageDropped(int metadata) {
        return metadata % 4;
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z);
        if (l < 4) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.25), (double)y, (double)((double)z + 0.25), (double)((double)x + 0.75), (double)((double)y + 0.5), (double)((double)z + 0.75));
        }
        if (l < 8) {
            return AxisAlignedBB.getBoundingBox((double)((double)x + 0.125), (double)y, (double)((double)z + 0.125), (double)((double)x + 0.875), (double)((double)y + 0.75), (double)((double)z + 0.875));
        }
        return AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int x, int y, int z) {
        float maxY;
        float maxX;
        float maxZ;
        float minX;
        float minZ;
        int md = iblockaccess.getBlockMetadata(x, y, z);
        float minY = 0.0f;
        if (md < 4) {
            minZ = 0.25f;
            minX = 0.25f;
            maxZ = 0.75f;
            maxX = 0.75f;
            maxY = 0.5f;
        } else if (md < 8) {
            minZ = 0.125f;
            minX = 0.125f;
            maxZ = 0.875f;
            maxX = 0.875f;
            maxY = 0.75f;
        } else {
            minZ = 0.0f;
            minX = 0.0f;
            maxZ = 1.0f;
            maxX = 1.0f;
            maxY = 1.0f;
        }
        this.setBlockBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player) {
        int meta;
        if (!world.isRemote && (meta = world.getBlockMetadata(x, y, z)) >= 12) {
            world.setBlock(x, y, z, (Block)this, meta - 4, 3);
            EntityItem entityitem = new EntityItem(world, player.posX, player.posY - 1.0, player.posZ, new ItemStack(NContent.berryItem, 1, meta - 12));
            world.spawnEntityInWorld((Entity)entityitem);
            if (!(player instanceof FakePlayer)) {
                entityitem.onCollideWithPlayer(player);
            }
        }
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta >= 12) {
            if (world.isRemote) {
                return true;
            }
            world.setBlock(x, y, z, (Block)this, meta - 4, 3);
            EntityItem entityitem = new EntityItem(world, player.posX, player.posY - 1.0, player.posZ, new ItemStack(NContent.berryItem, 1, meta - 12));
            world.spawnEntityInWorld((Entity)entityitem);
            if (!(player instanceof FakePlayer)) {
                entityitem.onCollideWithPlayer(player);
            }
            return true;
        }
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public void setGraphicsLevel(boolean flag) {
        this.field_150121_P = flag;
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return BerryRender.berryModel;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l > 7 || this.field_150121_P) {
            return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
        }
        return true;
    }

    public void updateTick(World world, int x, int y, int z, Random random1) {
        if (world.isRemote) {
            return;
        }
        int height = 1;
        while (world.getBlock(x, y - height, z) == this) {
            ++height;
        }
        if (random1.nextInt(20) == 0 && world.getBlockLightValue(x, y, z) >= 8) {
            int md = world.getBlockMetadata(x, y, z);
            if (md < 12) {
                world.setBlock(x, y, z, (Block)this, md + 4, 3);
            }
            if (random1.nextInt(3) == 0 && height < 3 && world.getBlock(x, y + 1, z) == Blocks.air && md >= 8) {
                world.setBlock(x, y + 1, z, (Block)this, md % 4, 3);
            }
        }
    }

    public boolean canSustainPlant(World world, int x, int y, int z, ForgeDirection direction, IPlantable plant) {
        if (plant instanceof BerryBush) {
            return world.getBlockMetadata(x, y, z) > 7;
        }
        return super.canSustainPlant((IBlockAccess)world, x, y, z, direction, plant);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 25;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int var4 = 12; var4 < 16; ++var4) {
            par3List.add(new ItemStack(par1, 1, var4));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.getBlockMetadata(x, y, z) - 4;
    }

    public boolean boneFertilize(World world, int x, int y, int z, Random random) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta / 4 < 2) {
            int setMeta = random.nextInt(2) + 1 + meta / 4;
            if (setMeta > 2) {
                setMeta = 2;
            }
            world.setBlockMetadataWithNotify(x, y, z, meta % 4 + setMeta * 4, 4);
            return true;
        }
        Block block = world.getBlock(x, y + 1, z);
        if (block == null || world.isAirBlock(x, y + 1, z)) {
            if (random.nextInt(3) == 0) {
                world.setBlock(x, y + 1, z, (Block)this, meta % 4, 3);
            }
            return true;
        }
        return false;
    }
}

