/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.trees;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mods.natura.common.NaturaTab;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class WillowBlock
extends BlockLog {
    public IIcon[] icons;
    public String[] textureNames = new String[]{"willow_bark", "willow_heart"};

    public WillowBlock() {
        this.setHardness(2.0f);
        this.setStepSound(Block.soundTypeWood);
        this.setCreativeTab((CreativeTabs)NaturaTab.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int metadata) {
        int tex = metadata % 4 * 2;
        int orientation = metadata / 4;
        switch (orientation) {
            case 0: {
                if (side != 0 && side != 1) break;
                return this.icons[tex + 1];
            }
            case 1: {
                if (side != 4 && side != 5) break;
                return this.icons[tex + 1];
            }
            case 2: {
                if (side != 2 && side != 3) break;
                return this.icons[tex + 1];
            }
        }
        return this.icons[tex];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[this.textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("natura:" + this.textureNames[i]);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList i = Lists.newArrayList();
        i.add(new ItemStack((Block)this));
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < this.icons.length / 2; ++i) {
            par3List.add(new ItemStack(par1, 1, i));
        }
    }
}

