/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.blocks.tech;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mods.natura.Natura;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RespawnObelisk
extends Block {
    @SideOnly(value=Side.CLIENT)
    IIcon activeTexture;

    public RespawnObelisk(Material material) {
        super(material);
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (player.isSneaking()) {
            return false;
        }
        player.setSpawnChunk(new ChunkCoordinates(x, y, z), false, world.provider.dimensionId);
        if (!world.isRemote) {
            player.addChatMessage(player.func_145748_c_().appendText("Spawn point set!"));
        }
        world.setBlockMetadataWithNotify(x, y, z, 1, 3);
        world.playSound((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "portal.portal", 1.0f, Natura.random.nextFloat() * 0.4f + 0.8f, false);
        return true;
    }

    public boolean isBed(IBlockAccess world, int x, int y, int z, EntityLivingBase player) {
        return world.getBlockMetadata(x, y, z) != 0;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            return 7;
        }
        return this.getLightValue();
    }

    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(World world, int x, int y, int z, Random random) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta > 0) {
            for (int i = 0; i < 2; ++i) {
                world.spawnParticle("portal", (double)((float)x + random.nextFloat() * 3.0f - 1.0f), (double)((float)y + random.nextFloat() * 2.0f), (double)((float)z + random.nextFloat() * 3.0f - 1.0f), 0.0, 0.0, 0.0);
                world.spawnParticle("witchMagic", (double)((float)x + random.nextFloat() * 3.0f - 1.0f), (double)((float)y + random.nextFloat() * 2.0f), (double)((float)z + random.nextFloat() * 3.0f - 1.0f), 0.0, 0.0, 0.0);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("natura:obelisk");
        this.activeTexture = iconRegister.registerIcon("natura:obelisk_active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return meta == 0 ? this.blockIcon : this.activeTexture;
    }
}

