/*
 * Decompiled with CFR 0.152.
 */
package mods.natura.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mods.natura.common.NContent;
import mods.natura.common.PHNatura;
import mods.natura.worldgen.BloodTreeLargeGen;
import mods.natura.worldgen.BushTreeGen;
import mods.natura.worldgen.DarkwoodGen;
import mods.natura.worldgen.EucalyptusTreeGenShort;
import mods.natura.worldgen.FusewoodGen;
import mods.natura.worldgen.GlowshroomGenBlueGreen;
import mods.natura.worldgen.GlowshroomGenPurple;
import mods.natura.worldgen.RareTreeGen;
import mods.natura.worldgen.RedwoodTreeGen;
import mods.natura.worldgen.SaguaroGen;
import mods.natura.worldgen.SakuraTreeGen;
import mods.natura.worldgen.WhiteTreeGen;
import mods.natura.worldgen.WillowGen;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BaseTreeWorldgen
implements IWorldGenerator {
    RedwoodTreeGen genRedwood = new RedwoodTreeGen(false, NContent.redwood);
    BloodTreeLargeGen genBlood = new BloodTreeLargeGen(3, 2);
    BushTreeGen bush = new BushTreeGen(false, 2, 3, 2);
    SakuraTreeGen pinkSakura = new SakuraTreeGen(false, 1, 0);
    WhiteTreeGen whiteSakura = new WhiteTreeGen(false, 2, 1);
    EucalyptusTreeGenShort eucalyptusShort = new EucalyptusTreeGenShort(0, 1);
    DarkwoodGen darkwood;
    FusewoodGen fusewood;
    SaguaroGen saguaro = new SaguaroGen(NContent.saguaro, 0, false);
    GlowshroomGenBlueGreen blueGreenGlowshroom;
    GlowshroomGenPurple purpleGlowshroom;
    RareTreeGen maple;
    RareTreeGen silverbell;
    RareTreeGen purpleheart;
    RareTreeGen tiger;
    WillowGen willow;
    public static boolean retrogen;

    public BaseTreeWorldgen() {
        this.darkwood = new DarkwoodGen(false, 3, 0);
        this.fusewood = new FusewoodGen(false, 3, 1);
        this.silverbell = new RareTreeGen(false, 4, 2, 1, 1);
        this.purpleheart = new RareTreeGen(false, 9, 8, 2, 2);
        this.tiger = new RareTreeGen(false, 6, 4, 3, 3);
        this.maple = new RareTreeGen(false, 4, 2, 0, 0);
        this.willow = new WillowGen(false);
        this.blueGreenGlowshroom = new GlowshroomGenBlueGreen(false);
        this.purpleGlowshroom = new GlowshroomGenPurple(false);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int i;
        int zSpawn;
        int ySpawn;
        int xSpawn;
        int iter;
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        String biomeName = world.func_72959_q().func_76935_a((int)xPos, (int)zPos).field_76791_y;
        if (biomeName == null) {
            return;
        }
        if (biomeName == "Forest" || biomeName == "AutumnWoods" || biomeName == "BirchForest" || biomeName == "PineForest" || biomeName == "Rainforest" || biomeName == "TemperateRainforest" || biomeName == "Woodlands") {
            if (PHNatura.generateSakura && random.nextInt(PHNatura.sakuraSpawnRarity * 5) == 0) {
                for (iter = 0; iter < 3; ++iter) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = random.nextInt(PHNatura.sakuraSpawnRange) + PHNatura.seaLevel;
                    zSpawn = zPos + random.nextInt(16);
                    this.pinkSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt(PHNatura.eucalyptusShortSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(PHNatura.eucalyptusShortSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16);
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "Plains" || biomeName == "Meadow") {
            if (!retrogen && PHNatura.generateRedwood && random.nextInt(PHNatura.redwoodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.genRedwood.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 16, zSpawn);
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt((int)((double)PHNatura.eucalyptusShortSpawnRarity * 1.5)) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = random.nextInt(32) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16);
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "Extreme Hills" || biomeName == "Extreme Hills Edge" || biomeName == "ForestedHills" || biomeName == "GreenHills") {
            if (PHNatura.generateBush && random.nextInt(PHNatura.bushSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16) + 8;
                ySpawn = random.nextInt(PHNatura.bushSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16) + 8;
                this.bush.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateSmallEucalyptus && random.nextInt(PHNatura.eucalyptusShortSpawnRarity) < 10) {
                xSpawn = xPos + random.nextInt(16) + 8;
                ySpawn = random.nextInt(PHNatura.eucalyptusShortSpawnRange) + PHNatura.seaLevel;
                zSpawn = zPos + random.nextInt(16) + 8;
                this.eucalyptusShort.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
        }
        if (biomeName == "River") {
            if (PHNatura.generateSakura && random.nextInt(PHNatura.sakuraSpawnRarity) == 0) {
                for (iter = 0; iter < 3; ++iter) {
                    xSpawn = xPos + random.nextInt(16);
                    ySpawn = random.nextInt(PHNatura.sakuraSpawnRange) + PHNatura.seaLevel;
                    zSpawn = zPos + random.nextInt(16);
                    this.pinkSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
            if (PHNatura.generateWillow && random.nextInt(PHNatura.willowRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.willow.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 16, zSpawn);
            }
        }
        if ((biomeName == "Desert" || biomeName == "DesertHills") && PHNatura.generateSaguaro && random.nextInt(PHNatura.saguaroSpawnRarity) == 0) {
            xSpawn = xPos + random.nextInt(16);
            ySpawn = random.nextInt(PHNatura.seaLevel) + 16;
            zSpawn = zPos + random.nextInt(16);
            this.saguaro.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
        }
        if ((biomeName == "Jungle" || biomeName == "JungleHills" || biomeName == "Extreme Jungle") && PHNatura.generatePurpleheart) {
            xSpawn = xPos + random.nextInt(16);
            zSpawn = zPos + random.nextInt(16);
            this.purpleheart.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 48, zSpawn);
        }
        if (biomeName == "Forest" || biomeName == "Woodlands" || biomeName == "AutumnWoods") {
            if (PHNatura.generateMaple && random.nextInt(PHNatura.mapleRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.maple.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 48, zSpawn);
            }
            if (PHNatura.generateSilverbell && random.nextInt(PHNatura.silverbellRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.silverbell.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 48, zSpawn);
            }
        }
        if ((biomeName == "Forest" || biomeName == "Rainforest" || biomeName == "TemperateRainforest") && PHNatura.generateTiger && random.nextInt(PHNatura.tigerRarity) == 0) {
            xSpawn = xPos + random.nextInt(16);
            zSpawn = zPos + random.nextInt(16);
            this.tiger.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 48, zSpawn);
        }
        if ((biomeName == "Swampland" || biomeName == "ForestHills") && PHNatura.generateWillow && random.nextInt(PHNatura.willowRarity) == 0) {
            for (i = 0; i < 3; ++i) {
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.willow.func_76484_a(world, random, xSpawn, PHNatura.seaLevel + 16, zSpawn);
            }
        }
        if (biomeName.equals("Hell") || biomeName.equals("Boneyard") || biomeName.equals("Phantasmagoric Inferno") || biomeName.equals("Corrupted Sands") || biomeName.equals("Corrupted Sands")) {
            if (PHNatura.generateBloodwood && random.nextInt(PHNatura.bloodSpawnRarity) == 0) {
                xSpawn = xPos + random.nextInt(16);
                ySpawn = 72;
                zSpawn = zPos + random.nextInt(16);
                this.genBlood.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateGhost && random.nextInt(PHNatura.ghostSpawnRarity) == 0) {
                for (iter = 0; iter < 3; ++iter) {
                    ySpawn = random.nextInt(80) + 16;
                    xSpawn = xPos + random.nextInt(16);
                    zSpawn = zPos + random.nextInt(16);
                    this.whiteSakura.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
            if (PHNatura.generateDarkwood && random.nextInt(PHNatura.darkSpawnRarity) == 0) {
                ySpawn = random.nextInt(64) + 32;
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.darkwood.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateFusewood && random.nextInt(PHNatura.fuseSpawnRarity) == 0) {
                ySpawn = random.nextInt(64) + 32;
                xSpawn = xPos + random.nextInt(16);
                zSpawn = zPos + random.nextInt(16);
                this.fusewood.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
            }
            if (PHNatura.generateThornvines && random.nextInt(PHNatura.thornSpawnRarity) == 0) {
                ySpawn = 108;
                for (i = 0; i < 20; ++i) {
                    int vineMeta = random.nextInt(16);
                    xSpawn = xPos + random.nextInt(16);
                    zSpawn = zPos + random.nextInt(16);
                    int size = random.nextInt(25) + 1;
                    int height = ySpawn - (random.nextInt(size) + random.nextInt(size) + random.nextInt(size));
                    for (int yHeight = ySpawn; yHeight > height; --yHeight) {
                        if (world.func_147439_a(xSpawn, yHeight, zSpawn) != Blocks.field_150350_a) continue;
                        world.func_147465_d(xSpawn, yHeight, zSpawn, NContent.thornVines, vineMeta, 2);
                    }
                }
            }
            if (random.nextInt(35) == 0) {
                for (i = 0; i < 5; ++i) {
                    WorldGenerator obj = random.nextInt(3) == 0 ? this.purpleGlowshroom : this.blueGreenGlowshroom;
                    xSpawn = xPos + random.nextInt(24) - 4;
                    zSpawn = zPos + random.nextInt(24) - 4;
                    ySpawn = this.findGround(world, xSpawn, random.nextInt(64) + 32, zSpawn);
                    if (ySpawn == -1) continue;
                    obj.func_76484_a(world, random, xSpawn, ySpawn, zSpawn);
                }
            }
        }
    }

    int findGround(World world, int x, int y, int z) {
        boolean foundGround = false;
        int height = y;
        do {
            Block underID;
            if ((underID = world.func_147439_a(x, --height, z)) != Blocks.field_150424_aL && underID != Blocks.field_150425_aM && underID != NContent.taintedSoil && height >= 0) continue;
            foundGround = true;
        } while (!foundGround);
        return height + 1;
    }
}

