package slimeknights.tconstruct.gadgets.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import scala.None;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockPunji extends Block {

  public static final PropertyDirection FACING = PropertyDirection.func_177714_a("facing");
  //public static final PropertyEnum<ConnectionHorizontal> CON_HOR = PropertyEnum.create("connection_horizontal", ConnectionHorizontal.class);
  //public static final PropertyEnum<ConnectionDiagonal> CON_DIA = PropertyEnum.create("connection_diagonal", ConnectionDiagonal.class);
  //public static final PropertyEnum<ConnectionVertical> CON_VER = PropertyEnum.create("connection_vertical", ConnectionVertical.class);
  public static final PropertyBool NORTH = PropertyBool.func_177716_a("north");
  public static final PropertyBool EAST = PropertyBool.func_177716_a("east");
  public static final PropertyBool NORTHEAST = PropertyBool.func_177716_a("northeast");
  public static final PropertyBool NORTHWEST = PropertyBool.func_177716_a("northwest");

  public BlockPunji() {
    super(Material.field_151585_k);

    this.func_149676_a(0.125f, 0, 0.125f, 0.875f, 0.375f, 0.875f);
    this.func_149672_a(Block.field_149779_h);
    this.func_149647_a(TinkerRegistry.tabGadgets);
    this.func_149711_c(3.0f);

    this.func_180632_j(func_176194_O().func_177621_b().func_177226_a(FACING, EnumFacing.DOWN));
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, FACING, NORTH, EAST, NORTHEAST, NORTHWEST);
  }

  /**
   * Convert the given metadata into a BlockState for this Block
   */
  public IBlockState func_176203_a(int meta) {
    if(meta >= EnumFacing.values().length) {
      meta = EnumFacing.DOWN.ordinal();
    }
    EnumFacing face = EnumFacing.values()[meta];

    return this.func_176223_P().func_177226_a(FACING, face);
  }

  /**
   * Convert the BlockState into the correct metadata value
   */
  public int func_176201_c(IBlockState state) {
    return state.func_177229_b(FACING).ordinal();
  }

  @Override
  public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
    EnumFacing facing = state.func_177229_b(FACING);

    int off = -facing.ordinal() % 2;

    EnumFacing face1 = EnumFacing.values()[(facing.ordinal() + 2) % 6];
    EnumFacing face2 = EnumFacing.values()[(facing.ordinal() + 4 + off) % 6];

    // North/East Connector
    IBlockState north = worldIn.func_180495_p(pos.func_177972_a(face1));
    IBlockState east = worldIn.func_180495_p(pos.func_177972_a(face2));
    if(north.func_177230_c() == this && north.func_177229_b(FACING) == facing) {
      state = state.func_177226_a(NORTH, true);
    }
    if(east.func_177230_c() == this && east.func_177229_b(FACING) == facing) {
      state = state.func_177226_a(EAST, true);
    }

    // Diagonal connections
    IBlockState northeast = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2));
    IBlockState northwest = worldIn.func_180495_p(pos.func_177972_a(face1).func_177972_a(face2.func_176734_d()));
    if(northeast.func_177230_c() == this && northeast.func_177229_b(FACING) == facing) {
      state = state.func_177226_a(NORTHEAST, true);
    }
    if(northwest.func_177230_c() == this && northwest.func_177229_b(FACING) == facing) {
      state = state.func_177226_a(NORTHWEST, true);
    }


    return state;
  }

  /**
   * Called by ItemBlocks just before a block is actually set in the world, to allow for adjustments to the
   * IBlockstate
   */
  public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
    EnumFacing enumfacing = facing.func_176734_d();

    return this.func_176223_P().func_177226_a(FACING, enumfacing);
  }

  @Override
  public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
    return worldIn.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
  }

  @Override
  public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
    EnumFacing facing = state.func_177229_b(FACING);

    if (!worldIn.isSideSolid(pos.func_177972_a(facing), facing.func_176734_d(), true))
    {
      this.func_176226_b(worldIn, pos, state, 0);
      worldIn.func_175698_g(pos);
    }
  }

  @Override
  public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
    EnumFacing facing = worldIn.func_180495_p(pos).func_177229_b(FACING);
    setBlockBoundsBasedOnState(facing);
  }

  public void setBlockBoundsBasedOnState(EnumFacing facing) {
    float h = 0.375f;

    float xMin = 0.1875f;
    float xMax = 1f - xMin;
    float zMin = 0.1875f;
    float zMax = 1f - zMin;
    float yMin = 0.1875f;
    float yMax = 1f - yMin;

    switch(facing) {
      case DOWN:
        yMin = 0;
        yMax = h;
        break;
      case UP:
        yMin = 1f-h;
        yMax = 1;
        break;
      case SOUTH:
        zMin = 1f-h;
        zMax = 1;
        break;
      case NORTH:
        zMax = h;
        zMin = 0;
        break;
      case EAST:
        xMin = 1f-h;
        xMax = 1;
        break;
      case WEST:
        xMax = h;
        xMin = 0;
        break;
    }

    this.func_149676_a(xMin, yMin, zMin, xMax, yMax, zMax);
  }

  @Override
  public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
    setBlockBoundsBasedOnState(state.func_177229_b(FACING));
    return super.func_180640_a(worldIn, pos, state);
  }

  @Override
  public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
    if(entityIn instanceof EntityLiving) {
      float damage = 3f;
      if(entityIn.field_70143_R > 0) {
        damage += entityIn.field_70143_R * 1.5f + 2f;
      }
      entityIn.func_70097_a(DamageSource.field_76367_g, damage);
      ((EntityLiving) entityIn).func_70690_d(new PotionEffect(Potion.field_76421_d.func_76396_c(), 20, 1));
    }
  }

  @Override
  public boolean func_149662_c() {
    return false;
  }

  @Override
  public boolean func_149686_d() {
    return false;
  }

  private enum Corner implements IStringSerializable {
    NONE_UP,
    NORTH_DOWN,
    EAST_UP,
    EAST_DOWN,
    SOUTH_UP,
    SOUTH_DOWN,
    WEST_UP,
    WEST_DOWN;

    @Override
    public String func_176610_l() {
      return this.toString();
    }
  }
}
