package slimeknights.tconstruct.tools.traits;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

import java.util.ListIterator;

import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitAutosmelt extends AbstractTrait {

  public TraitAutosmelt() {
    super("autosmelt", 0xff5500);
  }

  @Override
  public boolean canApplyTogether(Enchantment enchantment) {
    return enchantment != Enchantment.field_77348_q;
  }

  @Override
  public void blockHarvestDrops(ItemStack tool, BlockEvent.HarvestDropsEvent event) {
    if(ToolHelper.isToolEffective(tool, event.state)) {
      // go through the drops and replace them with their furnace'd variant if applicable
      ListIterator<ItemStack> iter = event.drops.listIterator();
      while(iter.hasNext()) {
        ItemStack drop = iter.next();
        ItemStack smelted = FurnaceRecipes.func_77602_a().func_151395_a(drop);
        if(smelted != null) {
          smelted = smelted.func_77946_l();
          smelted.field_77994_a = drop.field_77994_a;
          int fortune = EnchantmentHelper.func_77517_e(event.harvester);
          if(Config.autosmeltlapis && fortune > 0) {
            smelted.field_77994_a *= random.nextInt(fortune + 1) + 1;
          }
          iter.set(smelted);

          // drop XP for it
          float xp = FurnaceRecipes.func_77602_a().func_151398_b(smelted);
          if(xp < 1 && Math.random() < xp) {
            xp += 1f;
          }
          if(xp >= 1f) {
            event.state.func_177230_c().func_180637_b(event.world, event.pos, (int) xp);
          }
        }
      }
    }
  }

  @Override
  public void afterBlockBreak(ItemStack tool, World world, Block block, BlockPos pos, EntityLivingBase player, boolean wasEffective) {
    if(world.field_72995_K && wasEffective) {
      for(int i = 0; i < 3; i++) {
        world.func_175688_a(EnumParticleTypes.FLAME,
                            pos.func_177958_n() + random.nextDouble(),
                            pos.func_177956_o() + random.nextDouble(), pos.func_177952_p() + random.nextDouble(),
                            0.0D, 0.0D, 0.0D);
      }
    }
  }
}
