package slimeknights.tconstruct.tools.network;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import io.netty.buffer.ByteBuf;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;

/**
 * Sent to the server when the user clicks on a tab in the TinkerStation GUI
 */
public class TinkerStationTabPacket extends AbstractPacketThreadsafe {

  public int blockX;
  public int blockY;
  public int blockZ;

  public TinkerStationTabPacket() {
  }

  @SideOnly(Side.CLIENT)
  public TinkerStationTabPacket(BlockPos pos) {
    this.blockX = pos.func_177958_n();
    this.blockY = pos.func_177956_o();
    this.blockZ = pos.func_177952_p();
  }

  @Override
  public void handleClientSafe(NetHandlerPlayClient netHandler) {
    // Serverside only
    throw new UnsupportedOperationException("Serverside only");
  }

  @Override
  public void handleServerSafe(NetHandlerPlayServer netHandler) {
    EntityPlayerMP player = netHandler.field_147369_b;

    ItemStack heldStack = null;
    if(player.field_71071_by.func_70445_o() != null) {
      heldStack = player.field_71071_by.func_70445_o();
      // set it to null so it's not getting dropped
      player.field_71071_by.func_70437_b(null);
    }

    BlockPos pos = new BlockPos(blockX, blockY, blockZ);
    IBlockState state = player.field_70170_p.func_180495_p(pos);
    if(state.func_177230_c() instanceof ITinkerStationBlock) {
      ((ITinkerStationBlock) state.func_177230_c()).openGui(player, player.field_70170_p, pos);
    }
    else {
      player.openGui(TConstruct.instance, 0, player.field_70170_p, blockX, blockY, blockZ);
    }

    // set held item again for the new container
    if(heldStack != null) {
      player.field_71071_by.func_70437_b(heldStack);
      // also send it to the client
      netHandler.func_147359_a(new S2FPacketSetSlot(-1, -1, heldStack));
    }
  }

  @Override
  public void fromBytes(ByteBuf buf) {
    blockX = buf.readInt();
    blockY = buf.readInt();
    blockZ = buf.readInt();
  }

  @Override
  public void toBytes(ByteBuf buf) {
    buf.writeInt(blockX);
    buf.writeInt(blockY);
    buf.writeInt(blockZ);
  }
}
