package slimeknights.tconstruct.tools.modifiers;

import com.google.common.collect.ImmutableList;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

import java.util.List;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.AbstractMaterialStats;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.modifiers.ModifierTrait;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class ModFiery extends ModifierTrait {

  public ModFiery() {
    super("fiery", 0xea9e32, 5, 25);
  }

  @Override
  public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
    dealFireDamage(tool, target);
  }

  protected void dealFireDamage(ItemStack tool, EntityLivingBase target) {
    NBTTagCompound tag = TinkerUtil.getModifierTag(tool, identifier);
    ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(tag);

    int duration = getFireDuration(data);
    target.func_70015_d(duration);

    // one heart fire damage per 15
    float fireDamage = getFireDamage(data);
    attackEntitySecondary(DamageSource.field_76372_a, fireDamage, target, false, true);
  }

  private float getFireDamage(ModifierNBT.IntegerNBT data) {
    return (float)data.current/15f;
  }

  private int getFireDuration(ModifierNBT.IntegerNBT data) {
    return 1 + data.current/8;
  }

  @Override
  public List<String> getExtraInfo(ItemStack tool, NBTTagCompound modifierTag) {
    String loc = String.format(LOC_Extra, getIdentifier());
    ModifierNBT.IntegerNBT data = ModifierNBT.readInteger(modifierTag);
    int duration = getFireDuration(data);
    float dmg = getFireDamage(data);

    return ImmutableList.of(
        Util.translateFormatted(loc, AbstractMaterialStats.df.format(dmg)),
        Util.translateFormatted(loc + 2, AbstractMaterialStats.df.format(duration))
    );
  }
}
