package slimeknights.tconstruct.tools.client.module;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetSlider;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.library.Util;

// a side inventory to be displayed to the left or right of another GUI
@SideOnly(Side.CLIENT)
public class GuiSideInventory extends GuiModule {

  protected GuiElementScalable overlap = GuiGeneric.overlap;
  protected GuiElement overlapTopLeft = GuiGeneric.overlapTopLeft;
  protected GuiElement overlapTopRight = GuiGeneric.overlapTopRight;
  protected GuiElement overlapBottomLeft = GuiGeneric.overlapBottomLeft;
  protected GuiElement overlapBottomRight = GuiGeneric.overlapBottomRight;
  protected GuiElement overlapTop = new GuiElement(7, 0, 7, 7, 64, 64); // same as borderTop but only 7 wide

  protected GuiElementScalable textBackground = GuiGeneric.textBackground;

  protected GuiElementScalable slot = GuiGeneric.slot;
  protected GuiElementScalable slotEmpty = GuiGeneric.slotEmpty;

  protected GuiElement sliderNormal = GuiGeneric.sliderNormal;
  protected GuiElement sliderLow = GuiGeneric.sliderLow;
  protected GuiElement sliderHigh = GuiGeneric.sliderHigh;
  protected GuiElement sliderTop = GuiGeneric.sliderTop;
  protected GuiElement sliderBottom = GuiGeneric.sliderBottom;
  protected GuiElementScalable sliderBackground = GuiGeneric.sliderBackground;

  // we use the chest gui as a preset for our parts
  protected static final ResourceLocation
      GUI_INVENTORY =
      Util.getResource("textures/gui/generic.png");

  protected GuiWidgetBorder border = new GuiWidgetBorder();

  protected int columns;
  protected int slotCount;

  protected int firstSlotId;
  protected int lastSlotId;

  protected int yOffset = 5;
  protected int xOffset;
  protected boolean connected;

  protected GuiWidgetSlider
      slider =
      new GuiWidgetSlider(sliderNormal, sliderHigh, sliderLow, sliderTop, sliderBottom, sliderBackground);

  public GuiSideInventory(GuiMultiModule parent, Container container, int slotCount, int columns) {
    this(parent, container, slotCount, columns, false, false);
  }

  public GuiSideInventory(GuiMultiModule parent, Container container, int slotCount, int columns, boolean rightSide, boolean connected) {
    super(parent, container, rightSide, false);

    this.connected = connected;

    this.columns = columns;
    this.slotCount = slotCount;

    this.field_146999_f = columns * slot.w + border.w*2;
    this.field_147000_g = calcCappedYSize(slot.h * 10);

    if(connected) {
      if(right) {
        border.cornerTopLeft = overlapTopLeft;
        border.borderLeft = overlap;
        border.cornerBottomLeft = overlapBottomLeft;
      }
      else {
        border.cornerTopRight = overlapTopRight;
        border.borderRight = overlap;
        border.cornerBottomRight = overlapBottomRight;
      }
    }

    yOffset = 0;

    updateSlots();
  }

  protected boolean shouldDrawName() {
    if(this.field_147002_h instanceof BaseContainer) {
      return ((BaseContainer) this.field_147002_h).getInventoryDisplayName() != null;
    }

    return false;
  }

  @Override
  public boolean shouldDrawSlot(Slot slot) {
    if(slot.getSlotIndex() >= slotCount) {
      return false;
    }
    // all visible
    if(!slider.isEnabled())
      return true;

    return firstSlotId <= slot.getSlotIndex() && lastSlotId > slot.getSlotIndex();
  }

  @Override
  public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
    return super.func_146981_a(slotIn, mouseX, mouseY) && shouldDrawSlot(slotIn);
  }

  public void updateSlotCount(int newSlotCount) {
    // don't do extra stuff if it's not needed
    if(slotCount == newSlotCount) return;

    this.slotCount = newSlotCount;
    // called twice to get correct slider calculation
    updatePosition(parent.cornerX, parent.cornerY, parent.realWidth, parent.realHeight);
    updatePosition(parent.cornerX, parent.cornerY, parent.realWidth, parent.realHeight);
  }

  @Override
  public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
    // at most as big as the parent
    this.field_147000_g = calcCappedYSize(parentSizeY - 10);
    // slider needed?
    if(getDisplayedRows() < getTotalRows()) {
      slider.enable();
      this.field_146999_f = columns * slot.w + slider.width +2*border.w;
    }
    else {
      slider.disable();
      this.field_146999_f = columns * slot.w + border.w*2;
    }

    // update position
    super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);

    // connected needs to move to the side
    if(connected) {
      if(yOffset == 0) {
        if(right) {
          border.cornerTopLeft = overlapTop;
        } else {
          border.cornerTopRight = overlapTop;
        }
      }

      xOffset = (border.w - 1) * (right ? -1 : 1);
      field_147003_i += xOffset;
    }
    else {
      xOffset = 0;
    }

    // move it a bit
    this.field_147009_r += yOffset;

    border.setPosition(field_147003_i, field_147009_r);
    border.setSize(field_146999_f, field_147000_g);

    int y = field_147009_r + border.h;
    int h = field_147000_g - border.h*2;

    if(shouldDrawName()) {
      y += textBackground.h;
      h -= textBackground.h;
    }
    slider.setPosition(field_147003_i + columns*slot.w + border.w, y);
    slider.setSize(h);
    slider.setSliderParameters(0, getTotalRows() - getDisplayedRows(), 1);

    updateSlots();
  }

  private int getDisplayedRows() {
    return slider.height/slot.h;
  }

  private int getTotalRows() {
    int total = slotCount / columns;
    if(slotCount % columns != 0)
      total++;

    return total;
  }

  private int calcCappedYSize(int max) {
    int h = slot.h * getTotalRows();

    h = border.getHeightWithBorder(h);

    if(shouldDrawName())
      h += textBackground.h;

    // not higher than the max
    while(h > max) {
      h -= slot.h;
    }
    return h;
  }

  // updates slot visibility
  protected void updateSlots() {
    firstSlotId = slider.getValue() * columns;
    lastSlotId = Math.min(slotCount, firstSlotId + getDisplayedRows() * columns);

    int xd = border.w + xOffset;
    int yd = border.h + yOffset;

    if(shouldDrawName())
      yd += textBackground.h;

    for(Object o : field_147002_h.field_75151_b) {
      Slot slot = (Slot) o;
      if(shouldDrawSlot(slot)) {
        // calc position of the slot
        int offset = slot.getSlotIndex() - firstSlotId;
        int x = (offset % columns) * this.slot.w;
        int y = (offset / columns) * this.slot.h;

        slot.field_75223_e = xd + x + 1;
        slot.field_75221_f = yd + y + 1;

        if(this.right) {
          slot.field_75223_e += parent.realWidth;
        } else {
          slot.field_75223_e -= this.field_146999_f;
        }
      }
      else {
        slot.field_75223_e = 0;
        slot.field_75221_f = 0;
      }
    }
  }

  @Override
  public void func_146979_b(int mouseX, int mouseY) {
    if(shouldDrawName()) {
      String name = ((BaseContainer)field_147002_h).getInventoryDisplayName().func_150260_c();
      this.field_146289_q.func_78276_b(name, border.w, border.h - 1, 0x404040);
    }
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    field_147003_i += border.w;
    field_147009_r += border.h;

    GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
    this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);

    int x = field_147003_i;// + border.w;
    int y = field_147009_r;// + border.h;
    int midW = field_146999_f - border.w*2;
    int midH = field_147000_g - border.h*2;

    border.draw();

    if(shouldDrawName()) {
      textBackground.drawScaledX(x,y, midW);
      y += textBackground.h;
    }

    this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);
    drawSlots(x,y);
/*
    // draw the connection to the main thing
    if(right) {
      x = guiLeft;
      y = guiTop;

      if(guiTop == parent.cornerY) {
        borderTop.drawScaledX(x, y, overlapTopLeft.w);
      }
      else {
        overlapTopLeft.draw(x, y);
      }
      y += cornerTopLeft.h;
      overlap.drawScaledY(x, y, midH);
      y += midH;
      if(guiBottom() == parent.cornerX + parent.realHeight) {
        borderBottom.drawScaledX(x, y, overlapBottomLeft.w);
      }
      else {
        overlapBottomLeft.draw(x, y);
      }
    }
    else if(slider.isEnabled()) {
      y = guiTop;

      borderTop.drawScaledX(x, y, cornerTopRight.w);
      y += cornerTopRight.h;
      overlap.drawScaledY(x, y, midH);
      y += midH;
      borderBottom.drawScaledX(x, y, cornerBottomRight.w);

      x = guiRight() - 1;
      y = guiTop;
      if(guiTop == parent.cornerY) {
        borderTop.drawScaledX(x, y, overlapTopRight.w);
      }
      else {
        overlapTopRight.draw(x, y);
      }
      y += cornerTopRight.h;
      overlap.drawScaledY(x, y, midH);
      y += midH;
      if(guiBottom() == parent.cornerX + parent.realHeight) {
        borderBottom.drawScaledX(x, y, overlapBottomRight.w);
      }
      else {
        overlapBottomRight.draw(x, y);
      }
    }
*/
    // slider
    if(slider.isEnabled()) {
      slider.update(mouseX, mouseY, !isMouseOverFullSlot(mouseX, mouseY) && isMouseInModule(mouseX, mouseY));
      slider.draw();

      updateSlots();
    }

    field_147003_i -= border.w;
    field_147009_r -= border.h;
  }

  protected int drawSlots(int xPos, int yPos) {
    int width = columns * slot.w;
    int height = field_147000_g - border.h*2;

    int fullRows = (lastSlotId - firstSlotId)/columns;
    int y;
    for(y = 0; y < fullRows * slot.h && y < height; y += slot.h) {
      slot.drawScaledX(xPos, yPos + y, width);
    }

    // draw partial row and unused slots
    int slotsLeft = (lastSlotId - firstSlotId) % columns;
    if(slotsLeft > 0) {
      slot.drawScaledX(xPos, yPos + y, slotsLeft * slot.w);
      // empty slots that don't exist
      slotEmpty.drawScaledX(xPos + slotsLeft * slot.w, yPos + y, width - slotsLeft * slot.w);
    }

    return width;
  }
}
