package slimeknights.tconstruct.smeltery.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;

import slimeknights.mantle.block.BlockInventory;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.tileentity.TileCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingBasin;
import slimeknights.tconstruct.smeltery.tileentity.TileCastingTable;

public class BlockCasting extends BlockInventory {

  public static final PropertyEnum<CastingType> TYPE = PropertyEnum.func_177709_a("type", CastingType.class);

  public BlockCasting() {
    super(Material.field_151576_e);
    func_149711_c(3F);
    func_149752_b(20F);
    func_149647_a(TinkerRegistry.tabSmeltery);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(CastingType type : CastingType.values()) {
      list.add(new ItemStack(this, 1, type.getMeta()));
    }
  }

  @Override
  protected BlockState func_180661_e() {
    return new ExtendedBlockState(this, new IProperty[]{TYPE}, new IUnlistedProperty[]{BlockTable.INVENTORY, BlockTable.FACING});
  }

  @Override
  public int func_176201_c(IBlockState state) {
    return state.func_177229_b(TYPE).getMeta();
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    if(meta < 0 || meta >= CastingType.values().length) {
      meta = 0;
    }
    return func_176223_P().func_177226_a(TYPE, CastingType.values()[meta]);
  }

  @Override
  public int func_180651_a(IBlockState state) {
    return func_176201_c(state);
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    switch(func_176203_a(meta).func_177229_b(TYPE)) {
      case TABLE:
        return new TileCastingTable();
      case BASIN:
        return new TileCastingBasin();
    }
    return null;
  }

  @Override
  public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float clickX, float clickY, float clickZ) {
    if(player.func_70093_af()) {
      return false;
    }
    TileEntity te = world.func_175625_s(pos);
    if(te instanceof TileCasting) {
      ((TileCasting) te).interact(player);
      return true;
    }

    return super.func_180639_a(world, pos, state, player, side, clickX, clickY, clickZ);
  }

  @Override
  public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    super.func_180633_a(world, pos, state, placer, stack);

    // we have rotation for the stuff too so the items inside rotate according to placement!
    TileEntity te = world.func_175625_s(pos);
    if(te != null && te instanceof TileCasting) {
      ((TileCasting) te).setFacing(placer.func_174811_aO().func_176734_d());
    }
  }

  @Override
  @SideOnly(Side.CLIENT)
  public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
    IExtendedBlockState extendedState = (IExtendedBlockState) state;

    TileEntity te = world.func_175625_s(pos);
    if(te != null && te instanceof TileCasting) {
      TileCasting tile = (TileCasting) te;
      return tile.writeExtendedBlockState(extendedState);
    }

    return super.getExtendedState(state, world, pos);
  }

  @Override
  protected boolean openGui(EntityPlayer player, World world, BlockPos pos) {
    // no gui
    return false;
  }

  @Override
  public boolean func_149662_c() {
    return false;
  }

  @Override
  public boolean func_149686_d() {
    return false;
  }

  @SideOnly(Side.CLIENT)
  public EnumWorldBlockLayer func_180664_k()
  {
    return EnumWorldBlockLayer.CUTOUT;
  }

  public enum CastingType implements IStringSerializable, EnumBlock.IEnumMeta {
    TABLE,
    BASIN;

    public final int meta;

    CastingType() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
