package slimeknights.tconstruct.library.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class TinkerPotion extends Potion {
  private final boolean show;

  public TinkerPotion(ResourceLocation location, boolean badEffect, boolean showInInventory) {
    this(location, badEffect, showInInventory, 0xffffff);
  }

  public TinkerPotion(ResourceLocation location, boolean badEffect, boolean showInInventory, int color) {
    super(location, badEffect, color);
    func_76390_b("potion." + location.func_110623_a());

    this.show = showInInventory;
  }

  @Override
  public boolean shouldRenderInvText(PotionEffect effect) {
    return show;
  }

  public PotionEffect apply(EntityLivingBase entity, int duration) {
    return apply(entity, duration, 0);
  }

  public PotionEffect apply(EntityLivingBase entity, int duration, int level) {
    PotionEffect effect = new PotionEffect(this.func_76396_c(), duration, level, false, false);
    entity.func_70690_d(effect);
    return effect;
  }

  public int getLevel(EntityLivingBase entity) {
    PotionEffect effect = entity.func_70660_b(this);
    if(effect != null) {
      return effect.func_76458_c();
    }
    return 0;
  }

  @Override
  public boolean shouldRender(PotionEffect effect) {
    return show;
  }
}
