package slimeknights.tconstruct.gadgets.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.RenderItemFrame;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.init.Items;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import slimeknights.tconstruct.gadgets.entity.EntityFancyItemFrame;
import slimeknights.tconstruct.library.Util;

@SideOnly(Side.CLIENT)
public class RenderFancyItemFrame extends RenderItemFrame {

  public static final IRenderFactory<EntityFancyItemFrame> FACTORY = new Factory();

  private final Minecraft mc = Minecraft.func_71410_x();
  public static final ModelResourceLocation mapModel = Util.getModelResource("fancy_frame", "map");

  public RenderFancyItemFrame(RenderManager renderManagerIn, RenderItem itemRendererIn) {
    super(renderManagerIn, itemRendererIn);
  }

  @Override
  public void func_76986_a(EntityItemFrame entity, double x, double y, double z, float entityYaw, float partialTicks)
  {
    GlStateManager.func_179094_E();
    BlockPos blockpos = entity.func_174857_n();
    double d0 = (double)blockpos.func_177958_n() - entity.field_70165_t + x;
    double d1 = (double)blockpos.func_177956_o() - entity.field_70163_u + y;
    double d2 = (double)blockpos.func_177952_p() - entity.field_70161_v + z;
    GlStateManager.func_179137_b(d0 + 0.5D, d1 + 0.5D, d2 + 0.5D);
    GlStateManager.func_179114_b(180.0F - entity.field_70177_z, 0.0F, 1.0F, 0.0F);
    this.field_76990_c.field_78724_e.func_110577_a(TextureMap.field_110575_b);
    BlockRendererDispatcher blockrendererdispatcher = this.mc.func_175602_ab();
    ModelManager modelmanager = blockrendererdispatcher.func_175023_a().func_178126_b();
    IBakedModel ibakedmodel;

    if (entity.func_82335_i() != null && entity.func_82335_i().func_77973_b() == Items.field_151098_aY)
    {
      ibakedmodel = modelmanager.func_174953_a(mapModel);
    }
    else
    {
      ibakedmodel = modelmanager.func_174953_a(Util.getModelResource("fancy_frame", ((EntityFancyItemFrame)entity).getType()));
    }

    GlStateManager.func_179094_E();
    GlStateManager.func_179109_b(-0.5F, -0.5F, -0.5F);
    blockrendererdispatcher.func_175019_b().func_178262_a(ibakedmodel, 1.0F, 1.0F, 1.0F, 1.0F);
    GlStateManager.func_179121_F();
    GlStateManager.func_179109_b(0.0F, 0.0F, 0.4375F);
    this.func_82402_b(entity);
    GlStateManager.func_179121_F();
    this.func_177067_a(entity, x + (double)((float)entity.field_174860_b.func_82601_c() * 0.3F), y - 0.25D, z + (double)((float)entity.field_174860_b.func_82599_e() * 0.3F));
  }

  private static class Factory implements IRenderFactory<EntityFancyItemFrame> {

    @Override
    public Render<? super EntityFancyItemFrame> createRenderFor(RenderManager manager) {
      return new RenderFancyItemFrame(manager, Minecraft.func_71410_x().func_175599_af());
    }
  }
}
