/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockTallSlimeGrass
extends BlockBush
implements IShearable {
    public static PropertyEnum<SlimePlantType> TYPE = PropertyEnum.create((String)"type", SlimePlantType.class);
    public static PropertyEnum<BlockSlimeGrass.FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

    public BlockTallSlimeGrass() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setStepSound(soundTypeGrass);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (SlimePlantType type : SlimePlantType.values()) {
            for (BlockSlimeGrass.FoliageType foliage : BlockSlimeGrass.FoliageType.values()) {
                list.add(new ItemStack((Block)this, 1, this.getMetaFromState(this.getDefaultState().withProperty(TYPE, (Comparable)((Object)type)).withProperty(FOLIAGE, (Comparable)((Object)foliage)))));
            }
        }
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FOLIAGE});
    }

    public int getMetaFromState(IBlockState state) {
        int meta = ((SlimePlantType)((Object)state.getValue(TYPE))).getMeta();
        return meta |= ((BlockSlimeGrass.FoliageType)((Object)state.getValue(FOLIAGE))).ordinal() << 2;
    }

    public IBlockState getStateFromMeta(int meta) {
        int foliage;
        int type = meta & 3;
        if (type >= SlimePlantType.values().length) {
            type = 0;
        }
        if ((foliage = meta >> 2) >= BlockSlimeGrass.FoliageType.values().length) {
            foliage = 0;
        }
        IBlockState state = this.getDefaultState();
        state = state.withProperty(TYPE, (Comparable)((Object)SlimePlantType.values()[type]));
        state = state.withProperty(FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.values()[foliage]));
        return state;
    }

    public boolean isReplaceable(World worldIn, BlockPos pos) {
        return true;
    }

    public int getDamageValue(World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.getBlockState(pos);
        return iblockstate.getBlock().getMetaFromState(iblockstate);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return null;
    }

    protected boolean canPlaceBlockOn(Block ground) {
        return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
    }

    @SideOnly(value=Side.CLIENT)
    public Block.EnumOffsetType getOffsetType() {
        return Block.EnumOffsetType.XYZ;
    }

    public int getBlockColor() {
        return SlimeColorizer.colorBlue;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.getValue(FOLIAGE));
        return SlimeColorizer.getColorStatic(foliageType);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.getBlockState(pos);
        if (state.getBlock() != this) {
            return this.getBlockColor();
        }
        BlockSlimeGrass.FoliageType foliageType = (BlockSlimeGrass.FoliageType)((Object)state.getValue(FOLIAGE));
        return SlimeColorizer.getColorForPos(pos, foliageType);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return TinkerWorld.slimePlantType;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.getBlockState(pos);
        ItemStack stack = new ItemStack((Block)this, 1, this.getMetaFromState(state));
        return Lists.newArrayList((Object[])new ItemStack[]{stack});
    }

    public static enum SlimePlantType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        TALL_GRASS,
        FERN;

        public final int meta = this.ordinal();

        public int getMeta() {
            return this.meta;
        }

        public String getName() {
            return this.toString();
        }
    }
}

