/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.mantle.tileentity.TileInventory;

public class InventorySlotSyncPacket
extends AbstractPacketThreadsafe {
    public ItemStack itemStack;
    public int slot;
    public BlockPos pos;

    public InventorySlotSyncPacket() {
    }

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.pos = pos;
        this.slot = slot;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        TileEntity tileEntity = Minecraft.getMinecraft().thePlayer.worldObj.getTileEntity(this.pos);
        if (tileEntity == null || !(tileEntity instanceof TileInventory)) {
            return;
        }
        TileInventory tile = (TileInventory)tileEntity;
        tile.setInventorySlotContents(this.slot, this.itemStack);
        Minecraft.getMinecraft().renderGlobal.markBlockForUpdate(this.pos);
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        throw new UnsupportedOperationException("Clientside only");
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = this.readPos(buf);
        this.slot = buf.readShort();
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        this.writePos(this.pos, buf);
        buf.writeShort(this.slot);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
    }
}

