/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;

public class BroadSword
extends ToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.web, (Object)Material.vine, (Object)Material.coral, (Object)Material.gourd, (Object)Material.leaves);

    public BroadSword() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.swordBlade), PartMaterialType.extra(TinkerTools.wideGuard));
    }

    protected BroadSword(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.WEAPON);
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.getMaterial());
    }

    @Override
    public boolean canUseSecondaryItem() {
        return false;
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public int attackSpeed() {
        return 0;
    }

    @Override
    public float miningSpeedModifier() {
        return 0.5f;
    }

    public EnumAction getItemUseAction(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int getMaxItemUseDuration(ItemStack stack) {
        return 72000;
    }

    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        playerIn.setItemInUse(itemStackIn, this.getMaxItemUseDuration(itemStackIn));
        return itemStackIn;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        ToolNBT data = this.buildDefaultTag(materials);
        data.attack += 2.0f;
        return data.get();
    }
}

