/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.ToolClientEvents;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.client.RenderEvents;

public class ToolClientProxy
extends ClientProxy {
    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        this.toolBuildInfo();
    }

    @Override
    public void postInit() {
        MinecraftForge.EVENT_BUS.register((Object)new ToolClientEvents());
        RenderEvents renderEvents = new RenderEvents();
        MinecraftForge.EVENT_BUS.register((Object)renderEvents);
        ((IReloadableResourceManager)Minecraft.getMinecraft().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)renderEvents);
    }

    @Override
    public void registerModels() {
        Item tableItem = Item.getItemFromBlock((Block)TinkerTools.toolTables);
        ModelLoader.setCustomModelResourceLocation((Item)tableItem, (int)BlockToolTable.TableTypes.CraftingStation.meta, (ModelResourceLocation)ToolClientEvents.locCraftingStation);
        ModelLoader.setCustomModelResourceLocation((Item)tableItem, (int)BlockToolTable.TableTypes.StencilTable.meta, (ModelResourceLocation)ToolClientEvents.locStencilTable);
        ModelLoader.setCustomModelResourceLocation((Item)tableItem, (int)BlockToolTable.TableTypes.PartBuilder.meta, (ModelResourceLocation)ToolClientEvents.locPartBuilder);
        ModelLoader.setCustomModelResourceLocation((Item)tableItem, (int)BlockToolTable.TableTypes.ToolStation.meta, (ModelResourceLocation)ToolClientEvents.locToolStation);
        tableItem = Item.getItemFromBlock((Block)TinkerTools.toolForge);
        ModelLoader.setCustomModelResourceLocation((Item)tableItem, (int)0, (ModelResourceLocation)ToolClientEvents.locToolForge);
        ResourceLocation patternLoc = ToolClientEvents.locBlankPattern;
        CustomTextureCreator.patternModelLocation = new ResourceLocation(patternLoc.getResourceDomain(), "item/" + patternLoc.getResourcePath());
        ModelLoader.setCustomMeshDefinition((Item)TinkerTools.pattern, (ItemMeshDefinition)new ClientProxy.PatternMeshDefinition(patternLoc));
        for (ToolCore tool : TinkerTools.tools) {
            this.registerToolModel(tool);
        }
        this.registerPartModel(TinkerTools.shard);
        this.registerPartModel(TinkerTools.sharpeningKit);
        for (ToolPart part : TinkerTools.toolparts) {
            this.registerPartModel(part);
        }
        for (IModifier modifier : TinkerTools.modifiers) {
            if (modifier == TinkerTools.modCreative || modifier == TinkerTools.modHarvestWidth || modifier == TinkerTools.modHarvestHeight) continue;
            this.registerModifierModel(modifier, Util.getResource("models/item/modifiers/" + modifier.getIdentifier()));
        }
        this.registerModifierModel(new Modifier("fortify"){

            @Override
            public void updateNBT(NBTTagCompound modifierTag) {
            }

            @Override
            public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
            }

            @Override
            public boolean hasTexturePerMaterial() {
                return true;
            }
        }, Util.getResource("models/item/modifiers/fortify"));
    }

    public ResourceLocation registerPartModel(Item item) {
        ResourceLocation itemLocation = ToolClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        String path = "parts/" + itemLocation.getResourcePath() + MaterialModelLoader.EXTENSION;
        return this.registerMaterialModel(item, new ResourceLocation(itemLocation.getResourceDomain(), path));
    }

    public void toolBuildInfo() {
        ToolBuildGuiInfo info = new ToolBuildGuiInfo(TinkerTools.pickaxe);
        info.addSlotPosition(15, 60);
        info.addSlotPosition(53, 22);
        info.addSlotPosition(33, 42);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.shovel);
        info.addSlotPosition(33, 42);
        info.addSlotPosition(51, 24);
        info.addSlotPosition(13, 62);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.hatchet);
        info.addSlotPosition(22, 53);
        info.addSlotPosition(31, 22);
        info.addSlotPosition(51, 34);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.mattock);
        info.addSlotPosition(22, 53);
        info.addSlotPosition(31, 22);
        info.addSlotPosition(51, 34);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.broadSword);
        info.addSlotPosition(12, 62);
        info.addSlotPosition(47, 27);
        info.addSlotPosition(30, 44);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.longSword);
        info.addSlotPosition(12, 62);
        info.addSlotPosition(47, 27);
        info.addSlotPosition(30, 44);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.battleSign);
        info.addSlotPosition(27, 60);
        info.addSlotPosition(27, 34);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.fryPan);
        info.addSlotPosition(12, 62);
        info.addSlotPosition(34, 36);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.hammer);
        info.addSlotPosition(21, 52);
        info.addSlotPosition(44, 29);
        info.addSlotPosition(57, 48);
        info.addSlotPosition(25, 16);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.excavator);
        info.addSlotPosition(25, 46);
        info.addSlotPosition(45, 26);
        info.addSlotPosition(25, 26);
        info.addSlotPosition(7, 62);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.lumberAxe);
        info.addSlotPosition(32, 46);
        info.addSlotPosition(33, 22);
        info.addSlotPosition(53, 38);
        info.addSlotPosition(13, 62);
        TinkerRegistryClient.addToolBuilding(info);
        info = new ToolBuildGuiInfo(TinkerTools.cleaver);
        info.addSlotPosition(9, 64);
        info.addSlotPosition(25, 36);
        info.addSlotPosition(47, 30);
        info.addSlotPosition(33, 58);
        TinkerRegistryClient.addToolBuilding(info);
    }
}

