/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared.client;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import slimeknights.mantle.client.model.BlockItemModelWrapper;
import slimeknights.mantle.client.model.TRSRBakedModel;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;

public class BakedTableModel
implements ISmartBlockModel,
ISmartItemModel,
IFlexibleBakedModel {
    private final IFlexibleBakedModel standard;
    private final IRetexturableModel tableModel;
    private final Map<String, IFlexibleBakedModel> cache = Maps.newHashMap();
    private final Function<ResourceLocation, TextureAtlasSprite> textureGetter;

    public BakedTableModel(IFlexibleBakedModel standard, IRetexturableModel tableModel) {
        this.standard = standard;
        this.tableModel = tableModel;
        this.textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

            public TextureAtlasSprite apply(ResourceLocation location) {
                return Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            }
        };
    }

    public IBakedModel handleBlockState(IBlockState state) {
        String texture = null;
        List<PropertyTableItem.TableItem> items = Collections.emptyList();
        float rotation = 0.0f;
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            if (extendedState.getUnlistedNames().contains(BlockTable.TEXTURE)) {
                texture = (String)extendedState.getValue((IUnlistedProperty)BlockTable.TEXTURE);
            }
            if (Config.renderTableItems && extendedState.getUnlistedNames().contains(BlockTable.INVENTORY) && extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY) != null) {
                items = ((PropertyTableItem.TableItems)extendedState.getValue((IUnlistedProperty)BlockTable.INVENTORY)).items;
            }
            if (extendedState.getUnlistedNames().contains(BlockTable.FACING)) {
                EnumFacing face = (EnumFacing)extendedState.getValue((IUnlistedProperty)BlockTable.FACING);
                rotation = face != null ? 360.0f - (float)face.func_176734_d().func_176736_b() * 90.0f : 360.0f;
            }
        }
        if (texture == null && items == null) {
            return this.standard;
        }
        return this.getActualModel(texture, items, rotation);
    }

    public IBakedModel handleItemState(ItemStack stack) {
        ItemStack blockStack = ItemStack.func_77949_a((NBTTagCompound)TagUtil.getTagSafe(stack).func_74775_l("textureBlock"));
        if (blockStack == null) {
            return this.standard;
        }
        Block block = Block.func_149634_a((Item)blockStack.func_77973_b());
        String texture = ModelHelper.getTextureFromBlock(block, blockStack.func_77952_i()).func_94215_i();
        return this.getActualModel(texture, Collections.<PropertyTableItem.TableItem>emptyList(), 0.0f);
    }

    protected IFlexibleBakedModel getActualModel(String texture, List<PropertyTableItem.TableItem> items, float rotation) {
        if (this.cache.containsKey(texture)) {
            // empty if block
        }
        IFlexibleBakedModel bakedModel = this.standard;
        if (texture != null && this.tableModel != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"bottom", (Object)texture);
            builder.put((Object)"leg", (Object)texture);
            builder.put((Object)"legBottom", (Object)texture);
            IModel retexturedModel = this.tableModel.retexture(builder.build());
            bakedModel = retexturedModel.bake(retexturedModel.getDefaultState(), this.standard.getFormat(), this.textureGetter);
        }
        if (items != null && !items.isEmpty()) {
            ImmutableMap.Builder pb = ImmutableMap.builder();
            int i = 0;
            for (PropertyTableItem.TableItem item : items) {
                pb.put((Object)String.valueOf(i++), (Object)new TRSRBakedModel(item.model, item.x, item.y + 1.0f, item.z, item.r, (float)Math.PI, 0.0f, item.s));
            }
            bakedModel = new MultiModel.Baked(bakedModel, pb.build());
        }
        if (rotation < 360.0f) {
            bakedModel = new TRSRBakedModel(bakedModel, 0.0f, 0.0f, 0.0f, 0.0f, (float)Math.PI * (rotation / 180.0f), 0.0f, 1.0f);
        }
        bakedModel = new BlockItemModelWrapper(bakedModel);
        this.cache.put(texture, bakedModel);
        return bakedModel;
    }

    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return this.standard.func_177551_a(p_177551_1_);
    }

    public List<BakedQuad> func_177550_a() {
        return this.standard.func_177550_a();
    }

    public VertexFormat getFormat() {
        return this.standard.getFormat();
    }

    public boolean func_177555_b() {
        return this.standard.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.standard.func_177556_c();
    }

    public boolean func_177553_d() {
        return this.standard.func_177553_d();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.standard.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return this.standard.func_177552_f();
    }
}

