/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class TextureColoredTexture
extends AbstractColoredTexture {
    protected final TextureAtlasSprite addTexture;
    protected final String addTextureLocation;
    protected int[][] textureData;
    protected int textureW;
    protected int textureH;
    protected float scale;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean stencil = false;

    public TextureColoredTexture(String addTextureLocation, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTextureLocation;
        this.addTexture = null;
    }

    public TextureColoredTexture(TextureAtlasSprite addTexture, TextureAtlasSprite baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTexture.func_94215_i();
        this.addTexture = addTexture;
    }

    @Override
    protected int colorPixel(int pixel, int mipmap, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        if (this.textureData == null) {
            this.loadData();
        }
        int texCoord = pxCoord;
        if (this.field_130223_c > this.textureW) {
            int texX = pxCoord % this.field_130223_c % this.textureW;
            int texY = pxCoord / this.field_130224_d % this.textureH;
            texCoord = texY * this.textureW + texX;
        }
        int c = this.textureData[mipmap][texCoord];
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        if (!this.stencil) {
            r = TextureColoredTexture.mult(TextureColoredTexture.mult(r, RenderUtil.red(pixel)), RenderUtil.red(pixel));
            g = TextureColoredTexture.mult(TextureColoredTexture.mult(g, RenderUtil.green(pixel)), RenderUtil.green(pixel));
            b = TextureColoredTexture.mult(TextureColoredTexture.mult(b, RenderUtil.blue(pixel)), RenderUtil.blue(pixel));
        }
        return RenderUtil.compose(r, g, b, a);
    }

    protected void loadData() {
        if (this.addTexture != null && this.addTexture.func_110970_k() > 0) {
            this.textureData = this.addTexture.func_147965_a(0);
            this.scale = (float)this.addTexture.func_94211_a() / (float)this.field_130223_c;
            this.textureW = this.addTexture.func_94211_a();
            this.textureH = this.addTexture.func_94216_b();
        } else {
            int w = this.field_130223_c;
            int h = this.field_130224_d;
            this.textureData = this.backupLoadTexture(new ResourceLocation(this.addTextureLocation), Minecraft.func_71410_x().func_110442_L());
            this.scale = (float)this.field_130223_c / (float)w;
            this.textureW = this.field_130223_c;
            this.textureH = this.field_130224_d;
            this.field_130223_c = w;
            this.field_130224_d = h;
        }
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    protected int coord2(int x, int y) {
        return y * this.textureW + x;
    }
}

