/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.model;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemTransformVec3f;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;

public class ModelHelper {
    static final Type maptype = new TypeToken<Map<String, String>>(){}.getType();
    static final Type offsettype = new TypeToken<Offset>(){}.getType();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(maptype, (Object)ModelTextureDeserializer.INSTANCE).registerTypeAdapter(offsettype, (Object)OffsetDeserializer.INSTANCE).create();
    public static final IModelState DEFAULT_ITEM_STATE;
    public static final IModelState DEFAULT_TOOL_STATE;

    public static TextureAtlasSprite getTextureFromBlock(Block block, int meta) {
        IBlockState state = block.func_176203_a(meta);
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static TextureAtlasSprite getTextureFromBlockstate(IBlockState state) {
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
    }

    public static BakedQuad colorQuad(int color, BakedQuad quad) {
        int[] data = quad.func_178209_a();
        int a = color >> 24;
        if (a == 0) {
            a = 255;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        int c = r | g << 8 | b << 16 | a << 24;
        for (int i = 0; i < 4; ++i) {
            data[i * 7 + 3] = c;
        }
        return new IColoredBakedQuad.ColoredBakedQuad(data, -1, quad.func_178210_d());
    }

    public static Map<String, String> loadTexturesFromJson(ResourceLocation location) throws IOException {
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
        return (Map)GSON.fromJson((Reader)reader, maptype);
    }

    public static Offset loadOffsetFromJson(ResourceLocation location) throws IOException {
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
        return (Offset)GSON.fromJson((Reader)reader, offsettype);
    }

    public static ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> loadTransformFromJson(ResourceLocation location) throws IOException {
        IResource iresource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(location.func_110624_b(), location.func_110623_a() + ".json"));
        InputStreamReader reader = new InputStreamReader(iresource.func_110527_b(), Charsets.UTF_8);
        ModelBlock modelBlock = ModelBlock.func_178307_a((Reader)reader);
        ItemCameraTransforms itemCameraTransforms = modelBlock.func_181682_g();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ItemCameraTransforms.TransformType type : ItemCameraTransforms.TransformType.values()) {
            if (itemCameraTransforms.func_181688_b(type) == ItemTransformVec3f.field_178366_a) continue;
            builder.put((Object)type, (Object)new TRSRTransformation(itemCameraTransforms.func_181688_b(type)));
        }
        return builder.build();
    }

    public static ImmutableList<ResourceLocation> loadTextureListFromJson(ResourceLocation location) throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String s : ModelHelper.loadTexturesFromJson(location).values()) {
            builder.add((Object)new ResourceLocation(s));
        }
        return builder.build();
    }

    public static ResourceLocation getModelLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "models/" + location.func_110623_a() + ".json");
    }

    static {
        TRSRTransformation thirdperson = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.0625f, -0.1875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(-90.0f, 0.0f, 0.0f)), new Vector3f(0.55f, 0.55f, 0.55f), null));
        TRSRTransformation firstperson = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.125f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, -135.0f, 25.0f)), new Vector3f(1.7f, 1.7f, 1.7f), null));
        DEFAULT_ITEM_STATE = new SimpleModelState(ImmutableMap.of((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)thirdperson, (Object)ItemCameraTransforms.TransformType.FIRST_PERSON, (Object)firstperson));
        thirdperson = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.078125f, -0.21875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, 90.0f, -35.0f)), new Vector3f(0.85f, 0.85f, 0.85f), null));
        firstperson = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.25f, 0.125f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, -135.0f, 25.0f)), new Vector3f(1.7f, 1.7f, 1.7f), null));
        DEFAULT_TOOL_STATE = new SimpleModelState(ImmutableMap.of((Object)ItemCameraTransforms.TransformType.THIRD_PERSON, (Object)thirdperson, (Object)ItemCameraTransforms.TransformType.FIRST_PERSON, (Object)firstperson));
    }

    public static class Offset {
        public int x;
        public int y;
    }

    public static class OffsetDeserializer
    implements JsonDeserializer<Offset> {
        public static final OffsetDeserializer INSTANCE = new OffsetDeserializer();
        private static final Gson GSON = new Gson();

        public Offset deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("offset");
            if (texElem == null) {
                return new Offset();
            }
            return (Offset)GSON.fromJson(texElem, offsettype);
        }
    }

    public static class ModelTextureDeserializer
    implements JsonDeserializer<Map<String, String>> {
        public static final ModelTextureDeserializer INSTANCE = new ModelTextureDeserializer();
        private static final Gson GSON = new Gson();

        public Map<String, String> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            JsonElement texElem = obj.get("textures");
            if (texElem == null) {
                throw new JsonParseException("Missing textures entry in json");
            }
            return (Map)GSON.fromJson(texElem, maptype);
        }
    }
}

