package slimeknights.tconstruct.tools.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;

import java.util.List;

import io.netty.buffer.ByteBuf;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.tools.client.GuiStencilTable;
import slimeknights.tconstruct.tools.inventory.ContainerStencilTable;

public class StencilTableSelectionPacket extends AbstractPacketThreadsafe {

  public ItemStack output;

  public StencilTableSelectionPacket() {
  }

  public StencilTableSelectionPacket(ItemStack output) {
    this.output = output;
  }

  @Override
  public void handleClientSafe(NetHandlerPlayClient netHandler) {
    Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
    if(container instanceof ContainerStencilTable) {
      ((ContainerStencilTable) container).setOutput(output);
      if(Minecraft.func_71410_x().field_71462_r instanceof GuiStencilTable) {
        ((GuiStencilTable) Minecraft.func_71410_x().field_71462_r).onSelectionPacket(this);
      }
    }
  }

  @Override
  public void handleServerSafe(NetHandlerPlayServer netHandler) {
    Container container = netHandler.field_147369_b.field_71070_bA;
    if(container instanceof ContainerStencilTable) {
      ((ContainerStencilTable) container).setOutput(output);

      // find all people who also have the same gui open and update them too
      WorldServer server = netHandler.field_147369_b.func_71121_q();
      for(EntityPlayer player : (List<EntityPlayer>)server.field_73010_i) {
        if(player == netHandler.field_147369_b)
          continue;
        if(player.field_71070_bA instanceof ContainerStencilTable) {
          if(((BaseContainer) container).sameGui((BaseContainer) player.field_71070_bA)) {
            ((ContainerStencilTable) player.field_71070_bA).setOutput(output);
            // same gui, send him an update
            TinkerNetwork.sendTo(this, (EntityPlayerMP) player);
          }
        }
      }
    }
  }

  @Override
  public void fromBytes(ByteBuf buf) {
    output = ByteBufUtils.readItemStack(buf);
  }

  @Override
  public void toBytes(ByteBuf buf) {
    ByteBufUtils.writeItemStack(buf, output);
  }
}
