package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;

import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

import java.util.List;

import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;

public class Scythe extends ToolCore {
  public static final ImmutableSet<net.minecraft.block.material.Material> effective_materials =
      ImmutableSet.of(net.minecraft.block.material.Material.field_151569_G,
                      net.minecraft.block.material.Material.field_151584_j,
                      net.minecraft.block.material.Material.field_151585_k,
                      net.minecraft.block.material.Material.field_151577_b,
                      net.minecraft.block.material.Material.field_151582_l,
                      net.minecraft.block.material.Material.field_151572_C);


  public Scythe() {
    super(PartMaterialType.handle(TinkerTools.toolRod),
          PartMaterialType.head(TinkerTools.toolRod),
          PartMaterialType.handle(TinkerTools.toolRod),
          PartMaterialType.extra(TinkerTools.toughBinding)); // todo
  }

  @Override
  public float damagePotential() {
    return 1.3f;
  }

  @Override
  public boolean isEffective(Block block) {
    return effective_materials.contains(block.func_149688_o());
  }

  // special AOE block breaking against leaves
  @Override
  public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
    World world = player.field_70170_p;
    if(isEffective(world.func_180495_p(pos).func_177230_c())) {
      for(BlockPos extraPos : ToolHelper.calcAOEBlocks(itemstack, player.field_70170_p, player, pos, 5, 5, 5, 4)) {
        if(isEffective(world.func_180495_p(extraPos).func_177230_c())) {
          breakBlock(itemstack, extraPos, player);
        }
      }
    }

    return super.onBlockStartBreak(itemstack, pos, player);
  }

  private boolean isLeaves(BlockPos pos, EntityPlayer player) {
    return player.field_70170_p.func_180495_p(pos).func_177230_c().isLeaves(player.field_70170_p, pos);
  }

  protected void breakBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
    // silktouch gives us shears :D
    if(EnchantmentHelper.func_77506_a(Enchantment.field_77348_q.field_77352_x, stack) > 0) {
      if(ToolHelper.shearBlock(stack, player.field_70170_p, player, pos)) {
        return;
      }
    }

    // can't be sheared or no silktouch. break it
    ToolHelper.breakExtraBlock(stack, player.field_70170_p, player, pos, pos);
  }


  @Override
  public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
    // AOE attack!
    boolean hit = false;
    AxisAlignedBB box = AxisAlignedBB.func_178781_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70165_t + 1.0D, entity.field_70163_u + 1.0D, entity.field_70161_v + 1.0D).func_72314_b(1.0D, 1.0D, 1.0D);
    @SuppressWarnings("unchecked")
    List<Entity> entities = player.field_70170_p.func_72839_b(player, box);

    for(Entity target : entities) {
      hit |= ToolHelper.attackEntity(stack, this, player, target);
    }

    return hit;
  }

  @Override
  public boolean canUseSecondaryItem() {
    return false;
  }

  @Override
  public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {

    BlockPos start = new BlockPos(player);

    int d = 3;
    int distance = 3;

    for(int xp = start.func_177958_n() - d; xp != start.func_177958_n() + d; xp++) {
      for(int yp = start.func_177956_o() - d; yp != start.func_177956_o() + d; yp++) {
        for(int zp = start.func_177952_p() - d; zp != start.func_177952_p() + d; zp++) {
          if(MathHelper.func_76130_a(xp - start.func_177958_n()) + MathHelper.func_76130_a(yp - start.func_177956_o()) + MathHelper.func_76130_a(zp - start.func_177952_p()) >= distance) {
            continue;
          }
          BlockPos pos = new BlockPos(xp, yp, zp);
          // chop it down
          if(ToolHelper.isToolEffective2(itemStack, world.func_180495_p(pos))) {
            breakBlock(itemStack, pos, player);
          }
        }
      }
    }

    return itemStack;
  }

  @Override
  public int[] getRepairParts() {
    return new int[] {1,2};
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    HandleMaterialStats handle  = materials.get(0).getStatsOrUnknown(HandleMaterialStats.TYPE);
    HeadMaterialStats head      = materials.get(2).getStatsOrUnknown(HeadMaterialStats.TYPE);
    HandleMaterialStats handle2 = materials.get(1).getStatsOrUnknown(HandleMaterialStats.TYPE);
    ExtraMaterialStats binding  = materials.get(3).getStatsOrUnknown(ExtraMaterialStats.TYPE);

    ToolNBT data = new ToolNBT();

    return data.get();
  }
}
