package slimeknights.tconstruct.smeltery.block;

import com.google.common.collect.Lists;

import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;
import java.util.Random;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;

public class BlockTank extends BlockEnumSmeltery<BlockTank.TankType> {

  public static final PropertyEnum<TankType> TYPE = PropertyEnum.func_177709_a("type", TankType.class);
  public static final PropertyBool KNOB = PropertyBool.func_177716_a("has_knob");

  public BlockTank() {
    super(TYPE, TankType.class);

    func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(KNOB, false));
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    return new TileTank();
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, TYPE, KNOB);
  }

  @Override
  public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
    boolean hasKnob = (state.func_177229_b(TYPE)) == TankType.TANK && worldIn.func_175623_d(pos.func_177984_a());
    return super.func_176221_a(state, worldIn, pos).func_177226_a(KNOB, hasKnob);
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    IBlockState state = super.func_176203_a(meta);
    if(meta == TankType.TANK.getMeta()) {
      state = state.func_177226_a(KNOB, true);
    }
    return state;
  }

  @Override
  public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
    if(worldIn.field_72995_K) return true;

    TileEntity te = worldIn.func_175625_s(pos);
    if(!(te instanceof IFluidHandler)) {
      return false;
    }
    IFluidHandler tank = (IFluidHandler) te;
    side = side.func_176734_d();

    ItemStack stack = playerIn.func_70694_bm();
    if(stack == null) {
      return false;
    }

    // do the thing with the tank and the buckets
    if(FluidUtil.interactWithTank(stack, playerIn, tank, side)) {
      return true;
    }

    // prevent interaction of the item if it's a fluidcontainer. Prevents placing liquids when interacting with the tank
    return FluidContainerRegistry.isFilledContainer(stack) || stack.func_77973_b() instanceof IFluidContainerItem;
  }

  /* Block breaking retains the liquid */

  @Override
  public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
    TileEntity te = world.func_175625_s(pos);
    if(te instanceof TileTank && stack != null && stack.func_77942_o()) {
      ((TileTank) te).readTankFromNBT(stack.func_77978_p());
    }
  }

  @Override
  public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    // standard drop logic
    List<ItemStack> ret = Lists.newArrayList();
    Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
    Item item = this.func_180660_a(state, rand, fortune);
    ItemStack stack = null;
    if (item != null)
    {
      stack = new ItemStack(item, 1, this.func_180651_a(state));
      ret.add(stack);
    }


    // save liquid data on the stack
    TileEntity te = world.func_175625_s(pos);
    if(te instanceof TileTank && stack != null) {
      if(((TileTank) te).containsFluid()) {
        NBTTagCompound tag = new NBTTagCompound();
        ((TileTank) te).writeTankToNBT(tag);
        stack.func_77982_d(tag);
      }
    }
    return ret;
  }

  // fix blockbreak logic order. Needed to have the tile entity when getting the drops
  @Override
  public boolean removedByPlayer(World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
    // we pull up a few calls to this point in time because we still have the TE here
    // the execution otherwise is equivalent to vanilla order
    IBlockState state = world.func_180495_p(pos);
    this.func_176206_d(world, pos, state);
    if(willHarvest) {
      this.func_180657_a(world, player, pos, state, world.func_175625_s(pos));
    }

    world.func_175698_g(pos);
    // return false to prevent the above called functions to be called again
    // side effect of this is that no xp will be dropped. but it shoudln't anyway
    return false;
  }

  /* Rendering stuff etc */

  @Override
  public int getLightValue(IBlockAccess world, BlockPos pos) {
    TileEntity te = world.func_175625_s(pos);
    if(!(te instanceof TileTank)) {
      return 0;
    }
    TileTank tank = (TileTank) te;
    return tank.getBrightness();
  }

  @SideOnly(Side.CLIENT)
  public EnumWorldBlockLayer func_180664_k()
  {
    return EnumWorldBlockLayer.CUTOUT;
  }

  public boolean func_149686_d()
  {
    return false;
  }

  public boolean func_149662_c()
  {
    return false;
  }

  public enum TankType implements IStringSerializable, EnumBlock.IEnumMeta {
    TANK,
    GAUGE,
    WINDOW;

    public  final int meta;

    TankType() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
