package slimeknights.tconstruct.library.tools;

import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameData;

import java.text.DecimalFormat;
import java.util.List;

import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.utils.TagUtil;

public class Pattern extends Item implements IPattern {

  public static final DecimalFormat df = new DecimalFormat("#.##");

  public static final String TAG_PARTTYPE = "PartType";

  public Pattern() {
    this.func_77637_a(TinkerRegistry.tabParts);
    this.func_77627_a(true);
  }

  @Override
  public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
    subItems.add(new ItemStack(this));

    for(Item toolpart : TinkerRegistry.getPatternItems()) {
      ItemStack stack = new ItemStack(this);
      setTagForPart(stack, toolpart);

      subItems.add(stack);
    }
  }

  @Override
  public String func_77653_i(ItemStack stack) {
    Item part = getPartFromTag(stack);
    String unloc = this.func_77657_g(stack);
    if(part == null) {
      return Util.translate(unloc + ".blank");
    }

    return Util.translateFormatted(unloc + ".name", part.func_77653_i(null));
  }

  public static void setTagForPart(ItemStack stack, Item toolPart) {
    NBTTagCompound tag = TagUtil.getTagSafe(stack);

    tag.func_74778_a(TAG_PARTTYPE, toolPart.getRegistryName());

    stack.func_77982_d(tag);
  }

  public static Item getPartFromTag(ItemStack stack) {
    NBTTagCompound tag = TagUtil.getTagSafe(stack);
    String part = tag.func_74779_i(TAG_PARTTYPE);

    return GameData.getItemRegistry().func_82594_a(new ResourceLocation(part));
  }

  public boolean isBlankPattern(ItemStack stack) {
    if(stack == null || !(stack.func_77973_b() instanceof IPattern)) {
      return false;
    }

    if(!stack.func_77942_o()) {
      return true;
    }

    return Config.reuseStencil || !stack.func_77978_p().func_74764_b(TAG_PARTTYPE);
  }

  @Override
  public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
    Item part = getPartFromTag(stack);
    if(part != null && part instanceof IToolPart) {
      float cost = ((IToolPart)part).getCost() / (float) Material.VALUE_Ingot;
      tooltip.add(Util.translateFormatted("tooltip.pattern.cost", df.format(cost)));
    }
  }

  public static String getTextureIdentifier(Item item) {
    String identifier = item.getRegistryName();
    // sanitize it (remove modid)
    if(identifier.contains(":")) {
      identifier = identifier.substring(identifier.lastIndexOf(':') + 1);
    }

    return "_" + identifier;
  }
}
