package slimeknights.tconstruct.library;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

import java.util.IdentityHashMap;

import slimeknights.tconstruct.shared.TinkerCommons;


public class SlimeBounceHandler {

  private static final IdentityHashMap<Entity, SlimeBounceHandler> bouncingEntities = new IdentityHashMap<Entity, SlimeBounceHandler>();


  public final EntityLivingBase entityLiving;
  private int timer;
  private boolean wasInAir;
  private double bounce;
  private int bounceTick;

  private double lastMovX;
  private double lastMovZ;

  public SlimeBounceHandler(EntityLivingBase entityLiving, double bounce) {
    this.entityLiving = entityLiving;
    timer = 0;
    wasInAir = false;
    this.bounce = bounce;

    if(bounce != 0) {
      bounceTick = entityLiving.field_70173_aa;
    }
    else {
      bounceTick = 0;
    }

    bouncingEntities.put(entityLiving, this);
    //entityLiving.addChatMessage(new ChatComponentText("added " + entityLiving.worldObj.isRemote));
  }

  @SubscribeEvent
  public void playerTickPost(TickEvent.PlayerTickEvent event) {
    // this is only relevant for the local player
    if(event.phase == TickEvent.Phase.END && event.player == entityLiving) {
      // bounce up. This is to pcircumvent the logic that resets y motion after landing
      if(event.player.field_70173_aa == bounceTick) {
        event.player.field_70181_x = bounce;
        bounceTick = 0;
      }

      // preserve motion
      if(!entityLiving.field_70122_E && entityLiving.field_70173_aa != bounceTick) {
        if(lastMovX != entityLiving.field_70159_w || lastMovZ != entityLiving.field_70179_y) {
          double f = 0.91d + 0.025d;
          //System.out.println((entityLiving.worldObj.isRemote ? "client: " : "server: ") + entityLiving.motionX);
          entityLiving.field_70159_w /= f;
          entityLiving.field_70179_y /= f;
          entityLiving.field_70160_al = true;
          lastMovX = entityLiving.field_70159_w;
          lastMovZ = entityLiving.field_70179_y;
        }
      }

      // timing the effect out
      if(wasInAir && entityLiving.field_70122_E) {
        if(timer == 0) {
          timer = entityLiving.field_70173_aa;
        }
        else if(entityLiving.field_70173_aa - timer > 5) {
          MinecraftForge.EVENT_BUS.unregister(this);
          bouncingEntities.remove(entityLiving);
          //entityLiving.addChatMessage(new ChatComponentText("removed " + entityLiving.worldObj.isRemote));
        }
      }
      else {
        timer = 0;
        wasInAir = true;
      }
    }
  }

  public static void addBounceHandler(EntityLivingBase entity) {
    addBounceHandler(entity, 0d);
  }

  public static void addBounceHandler(EntityLivingBase entity, double bounce) {
    // only supports actual players as it uses the PlayerTick event
    if(!(entity instanceof EntityPlayer) || entity instanceof FakePlayer) {
      return;
    }
    SlimeBounceHandler handler = bouncingEntities.get(entity);
    if(handler == null) {
      // wasn't bouncing yet, register it
      MinecraftForge.EVENT_BUS.register(new SlimeBounceHandler(entity, bounce));
    }
    else if(bounce != 0) {
      // updated bounce if needed
      handler.bounce = bounce;
      handler.bounceTick = entity.field_70173_aa;
    }
  }
}
