package slimeknights.tconstruct.world.block;

import com.google.common.collect.Lists;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;
import java.util.Random;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass.FoliageType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockTallSlimeGrass extends BlockBush implements IShearable {

  public static PropertyEnum<SlimePlantType> TYPE = PropertyEnum.func_177709_a("type", SlimePlantType.class);
  public static PropertyEnum<FoliageType> FOLIAGE = BlockSlimeGrass.FOLIAGE;

  public BlockTallSlimeGrass() {
    func_149647_a(TinkerRegistry.tabWorld);
    this.func_149672_a(field_149779_h);
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(SlimePlantType type : SlimePlantType.values()) {
      for(FoliageType foliage : FoliageType.values()) {
        list.add(new ItemStack(this, 1, func_176201_c(func_176223_P().func_177226_a(TYPE, type).func_177226_a(FOLIAGE, foliage))));
      }
    }
  }

  /* State stuff */
  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, TYPE, FOLIAGE);
  }

  @Override
  public int func_176201_c(IBlockState state) {
    int meta = (state.func_177229_b(TYPE)).getMeta();
    meta |= (state.func_177229_b(FOLIAGE)).ordinal() << 2;

    return meta;
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    int type = meta & 3;
    if(type >= SlimePlantType.values().length) {
      type = 0;
    }

    int foliage = meta >> 2;
    if(foliage >= FoliageType.values().length) {
      foliage = 0;
    }
    IBlockState state = func_176223_P();
    state = state.func_177226_a(TYPE, SlimePlantType.values()[type]);
    state = state.func_177226_a(FOLIAGE, FoliageType.values()[foliage]);

    return state;
  }


  /* Logic stuff */

  @Override
  public boolean func_176200_f(World worldIn, BlockPos pos) {
    return true;
  }

  @Override
  public int func_176222_j(World worldIn, BlockPos pos) {
    IBlockState iblockstate = worldIn.func_180495_p(pos);
    return iblockstate.func_177230_c().func_176201_c(iblockstate);
  }

  @Override
  public Item func_180660_a(IBlockState state, Random rand, int fortune) {
    return null;
  }

  @Override
  protected boolean func_149854_a(Block ground) {
    return ground == TinkerWorld.slimeGrass || ground == TinkerWorld.slimeDirt;
  }

  /* Rendering Stuff */
  /**
   * Get the OffsetType for this Block. Determines if the model is rendered slightly offset.
   */
  @SideOnly(Side.CLIENT)
  public Block.EnumOffsetType func_176218_Q()
  {
    return Block.EnumOffsetType.XYZ;
  }

  @Override
  public int func_149635_D() {
    return SlimeColorizer.colorBlue;
  }

  // Used for the item
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180644_h(IBlockState state) {
    FoliageType foliageType = state.func_177229_b(FOLIAGE);
    return SlimeColorizer.getColorStatic(foliageType);
  }

  // Used for the block in world
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
    IBlockState state = worldIn.func_180495_p(pos);
    if(state.func_177230_c() != this) return func_149635_D();

    FoliageType foliageType = state.func_177229_b(FOLIAGE);
    return SlimeColorizer.getColorForPos(pos, foliageType);
  }

  /* Forge/MC callbacks */
  @Override
  public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
    return TinkerWorld.slimePlantType;
  }

  @Override
  public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
    return true;
  }

  @Override
  public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune)
  {
    IBlockState state = world.func_180495_p(pos);
    ItemStack stack = new ItemStack(this, 1, func_176201_c(state));
    return Lists.newArrayList(stack);
  }

  public enum SlimePlantType implements IStringSerializable, EnumBlock.IEnumMeta {
    TALL_GRASS,
    FERN;


    SlimePlantType() {
      this.meta = this.ordinal();
    }

    public final int meta;

    @Override
    public int getMeta() {
      return meta;
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }
  }
}
