package slimeknights.tconstruct.tools.inventory;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

import slimeknights.tconstruct.tools.tileentity.TileTinkerChest;
import slimeknights.tconstruct.tools.tileentity.TilePartChest;

public class ContainerPartChest extends ContainerTinkerStation<TilePartChest> {

  protected ContainerSideInventory<TilePartChest> inventory;

  public ContainerPartChest(InventoryPlayer playerInventory, TilePartChest tile) {
    super(tile);

    // chest inventory. we have it as a module
    inventory = new DynamicChestInventory(tile, tile, 8, 18, 8); // columns don't matter since they get set by gui
    this.addSubContainer(inventory, true);

    // player inventory
    this.addPlayerInventory(playerInventory, 8, 84);
  }

  // dynamic chest inventory as a module
  public static class DynamicChestInventory extends ContainerSideInventory<TilePartChest> {

    public DynamicChestInventory(TilePartChest tile, IInventory inventory, int x, int y, int columns) {
      super(tile, inventory, x, y, columns);

      // add the theoretically possible slots
      while(this.field_75151_b.size() < TileTinkerChest.MAX_INVENTORY) {
        this.func_75146_a(createSlot(inventory, this.field_75151_b.size(), 0,0));
      }
    }

    @Override
    protected Slot createSlot(IInventory inventory, int index, int x, int y) {
      return new PartSlot(tile, index, x, y);
    }
  }

  // slot that only accepts parts
  public static class PartSlot extends Slot {
    private final TilePartChest tile;

    public PartSlot(TilePartChest tile, int index, int xPosition, int yPosition) {
      super(tile, index, xPosition, yPosition);

      this.tile = tile;
    }

    @Override
    public boolean func_75214_a(ItemStack stack) {
      return tile.func_94041_b(this.getSlotIndex(), stack);
    }
  }
}
