package slimeknights.tconstruct.tools.client;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.client.module.GuiButtonsStencilTable;
import slimeknights.tconstruct.tools.client.module.GuiSideInventory;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;
import slimeknights.tconstruct.tools.inventory.ContainerStencilTable;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.network.StencilTableSelectionPacket;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;

@SideOnly(Side.CLIENT)
public class GuiStencilTable extends GuiTinkerStation {
  private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/stenciltable.png");

  public static final int Column_Count = 4;

  protected GuiButtonsStencilTable buttons;
  protected GuiSideInventory sideInventory;
  protected ContainerPatternChest.DynamicChestInventory chestContainer;

  public GuiStencilTable(InventoryPlayer playerInv, World world, BlockPos pos, TileStencilTable tile) {
    super(world, pos, (ContainerTinkerStation) tile.createContainer(playerInv, world, pos));

    buttons = new GuiButtonsStencilTable(this, field_147002_h, false);
    this.addModule(buttons);

    if(field_147002_h instanceof ContainerStencilTable) {
      ContainerStencilTable container = (ContainerStencilTable) field_147002_h;
      chestContainer = container.getSubContainer(ContainerPatternChest.DynamicChestInventory.class);
      if(chestContainer != null) {
        sideInventory = new GuiSideInventory(this, chestContainer, chestContainer.getSizeInventory(), chestContainer.columns, true, false);
        this.addModule(sideInventory);
      }
    }
  }

  public void onSelectionPacket(StencilTableSelectionPacket packet) {
    buttons.setSelectedbuttonByItem(packet.output);
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    drawBackground(BACKGROUND);

    if(sideInventory != null) {
      sideInventory.updateSlotCount(chestContainer.getSizeInventory());
    }

    drawIcon(field_147002_h.func_75139_a(0), ICON_Pattern);

    super.func_146976_a(partialTicks, mouseX, mouseY);
  }
}
