package slimeknights.tconstruct.tools;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;

import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.tools.block.BlockToolTable;
import slimeknights.tconstruct.tools.client.RenderEvents;

import static slimeknights.tconstruct.tools.TinkerTools.modCreative;
import static slimeknights.tconstruct.tools.TinkerTools.modHarvestHeight;
import static slimeknights.tconstruct.tools.TinkerTools.modHarvestWidth;
import static slimeknights.tconstruct.tools.TinkerTools.modifiers;
import static slimeknights.tconstruct.tools.TinkerTools.shard;
import static slimeknights.tconstruct.tools.TinkerTools.sharpeningKit;

public class ToolClientProxy extends ClientProxy {

  @Override
  public void preInit() {
    super.preInit();
  }

  @Override
  public void init() {
    toolBuildInfo();
  }

  @Override
  public void postInit() {
    MinecraftForge.EVENT_BUS.register(new ToolClientEvents());
    RenderEvents renderEvents = new RenderEvents();
    MinecraftForge.EVENT_BUS.register(renderEvents);
    ((IReloadableResourceManager) Minecraft.func_71410_x().func_110442_L()).func_110542_a(renderEvents);
  }

  @Override
  public void registerModels() {
    // blocks
    Item tableItem = Item.func_150898_a(TinkerTools.toolTables);
    ModelLoader.setCustomModelResourceLocation(tableItem, BlockToolTable.TableTypes.CraftingStation.meta, ToolClientEvents.locCraftingStation);
    ModelLoader.setCustomModelResourceLocation(tableItem, BlockToolTable.TableTypes.StencilTable.meta, ToolClientEvents.locStencilTable);
    ModelLoader.setCustomModelResourceLocation(tableItem, BlockToolTable.TableTypes.PartBuilder.meta, ToolClientEvents.locPartBuilder);
    ModelLoader.setCustomModelResourceLocation(tableItem, BlockToolTable.TableTypes.ToolStation.meta, ToolClientEvents.locToolStation);
    tableItem = Item.func_150898_a(TinkerTools.toolForge);
    ModelLoader.setCustomModelResourceLocation(tableItem, 0, ToolClientEvents.locToolForge);

    // general items

    //registerItemModel(new ItemStack(materials, 1, 2), "SlimeCrystalRed");

    // patterns
    final ResourceLocation patternLoc = ToolClientEvents.locBlankPattern;
    CustomTextureCreator.patternModelLocation = new ResourceLocation(patternLoc.func_110624_b(), "item/" + patternLoc.func_110623_a());
    ModelLoader.setCustomMeshDefinition(TinkerTools.pattern, new PatternMeshDefinition(patternLoc));

    // tools
    for(ToolCore tool : TinkerTools.tools) {
      registerToolModel(tool);
    }


    // parts
    registerPartModel(shard);
    registerPartModel(sharpeningKit);
    for(ToolPart part : TinkerTools.toolparts) {
      registerPartModel(part);
    }

    for(IModifier modifier : modifiers) {
      if(modifier == modCreative || modifier == modHarvestWidth || modifier == modHarvestHeight) {
        // modifiers without model are blacklisted
        continue;
      }
      registerModifierModel(modifier, Util.getResource("models/item/modifiers/" + modifier.getIdentifier()));
    }

    // we add a temporary modifier that does nothing to work around the model restrictions for the fortify modifier
    registerModifierModel(new Modifier("fortify") {
      @Override
      public void updateNBT(NBTTagCompound modifierTag) {
      }

      @Override
      public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {

      }

      @Override
      public boolean hasTexturePerMaterial() {
        return true;
      }
    }, Util.getResource("models/item/modifiers/fortify"));
  }

  public ResourceLocation registerPartModel(Item item) {
    ResourceLocation itemLocation = getItemLocation(item);
    if(itemLocation == null) {
      return null;
    }

    String path = "parts/" + itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION;

    return registerMaterialModel(item, new ResourceLocation(itemLocation.func_110624_b(), path));
  }

  public void toolBuildInfo() {
    // pickaxe
    ToolBuildGuiInfo info = new ToolBuildGuiInfo(TinkerTools.pickaxe);
    info.addSlotPosition(33-18, 42+18); // rod
    info.addSlotPosition(33+20, 42-20); // pick head
    info.addSlotPosition(33, 42); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // shovel
    info = new ToolBuildGuiInfo(TinkerTools.shovel);
    info.addSlotPosition(33, 42); // rod
    info.addSlotPosition(33+18, 42-18); // shovel head
    info.addSlotPosition(33-20, 42+20); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // hatchet
    info = new ToolBuildGuiInfo(TinkerTools.hatchet);
    info.addSlotPosition(33-11, 42+11); // rod
    info.addSlotPosition(33-2, 42-20); // head
    info.addSlotPosition(33+18, 42-8); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // mattock
    info = new ToolBuildGuiInfo(TinkerTools.mattock);
    info.addSlotPosition(33-11, 42+11); // rod
    info.addSlotPosition(33-2, 42-20); // axe head
    info.addSlotPosition(33+18, 42-8); // shovel head
    TinkerRegistryClient.addToolBuilding(info);

    // broadsword
    info = new ToolBuildGuiInfo(TinkerTools.broadSword);
    info.addSlotPosition(33-20-1, 42+20); // handle
    info.addSlotPosition(33+20-6, 42-20+5); // blade
    info.addSlotPosition(33-2-1, 42+2); // guard
    TinkerRegistryClient.addToolBuilding(info);

    // longsword
    info = new ToolBuildGuiInfo(TinkerTools.longSword);
    info.addSlotPosition(33-20-1, 42+20); // handle
    info.addSlotPosition(33+20-6, 42-20+5); // blade
    info.addSlotPosition(33-2-1, 42+2); // guard
    TinkerRegistryClient.addToolBuilding(info);
    // rapier
    // dagger

    // battlesign
    info = new ToolBuildGuiInfo(TinkerTools.battleSign);
    info.addSlotPosition(33-6, 42+18); // handle
    info.addSlotPosition(33-6, 42-8); // sign
    TinkerRegistryClient.addToolBuilding(info);

    // frypan
    info = new ToolBuildGuiInfo(TinkerTools.fryPan);
    info.addSlotPosition(33-20-1, 42+20); // handle
    info.addSlotPosition(33+2-1, 42-6); // pan
    TinkerRegistryClient.addToolBuilding(info);

    // hammer
    info = new ToolBuildGuiInfo(TinkerTools.hammer);
    info.addSlotPosition(33-10-2, 42+10); // handle
    info.addSlotPosition(33+13-2, 42-13); // head
    info.addSlotPosition(33+10+16-2, 42-10+16); // plate 1
    info.addSlotPosition(33+10-16-2, 42-10-16); // plate 2
    TinkerRegistryClient.addToolBuilding(info);

    // excavator
    info = new ToolBuildGuiInfo(TinkerTools.excavator);
    info.addSlotPosition(33-10+2, 42+4); // handle
    info.addSlotPosition(33+12, 42-16); // head
    info.addSlotPosition(33-8, 42-16); // plate
    info.addSlotPosition(33-10-16, 42+20); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // lumberaxe
    info = new ToolBuildGuiInfo(TinkerTools.lumberAxe);
    info.addSlotPosition(33+6-10+3, 42+4); // handle
    info.addSlotPosition(33+6-6, 42-20); // head
    info.addSlotPosition(33+6+14, 42-4); // plate
    info.addSlotPosition(33+6-10-16, 42+20); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // cleaver
    info = new ToolBuildGuiInfo(TinkerTools.cleaver);
    info.addSlotPosition(33-10-14, 42+10+12); // handle
    info.addSlotPosition(33-8, 42-10+4); // head
    info.addSlotPosition(33+14, 42-10-2); // plate/shield
    info.addSlotPosition(33+10-10, 42+10+6); // guard
    TinkerRegistryClient.addToolBuilding(info);

    // battleaxe
    /*info = new ToolBuildGuiInfo(TinkerTools.battleAxe);
    info.addSlotPosition(33-14, 42+10); // handle
    info.addSlotPosition(33+10-20, 42-10-10); // head 1
    info.addSlotPosition(33+10+6, 42-10+16); // head 2
    info.addSlotPosition(33+9, 42-13); // binding
    TinkerRegistryClient.addToolBuilding(info);

    // scythe
    info = new ToolBuildGuiInfo(TinkerTools.scythe);
    info.addSlotPosition(33-10, 42+10); // handle
    info.addSlotPosition(33+13, 42-13); // head
    info.addSlotPosition(33+10+16, 42-10+16); // plate
    info.addSlotPosition(33+10-16, 42-10-16); // binding
    TinkerRegistryClient.addToolBuilding(info);*/
  }
}
