package slimeknights.tconstruct.smeltery.block;

import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.common.PlayerHelper;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;

public class BlockSmelteryIO extends BlockEnumSmeltery<BlockSmelteryIO.IOType> {

  public final static PropertyEnum<IOType> TYPE = PropertyEnum.func_177709_a("type", IOType.class);
  public static PropertyDirection FACING = PropertyDirection.func_177712_a("facing", EnumFacing.Plane.HORIZONTAL);

  public BlockSmelteryIO() {
    super(TYPE, IOType.class);
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, TYPE, FACING);
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    int horIndex = (meta >> 2) & 0xF;
    return this.func_176223_P().func_177226_a(prop, fromMeta(meta)).func_177226_a(FACING, EnumFacing.field_176754_o[horIndex]);
  }

  @Override
  public int func_176201_c(IBlockState state) {
    // 4 direction states -> upper 2 bit for rotation
    return state.func_177229_b(prop).getMeta() | (state.func_177229_b(FACING).func_176736_b() << 2);
  }

  @Override
  public int func_180651_a(IBlockState state) {
    return state.func_177229_b(prop).getMeta(); // no rotation in the dropped drain
  }

  @Override
  public TileEntity func_149915_a(World worldIn, int meta) {
    return new TileDrain();
  }

  @Override
  public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
    EnumFacing side = placer.func_174811_aO().func_176734_d();
    // set rotation
    return this.func_176223_P().func_177226_a(FACING, side);
  }

  @Override
  public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
    // we allow to insert buckets into the smeltery
    TileEntity te = worldIn.func_175625_s(pos);
    if(!(te instanceof IFluidHandler)) {
      return false;
    }
    IFluidHandler tank = (IFluidHandler) te;
    side = side.func_176734_d();

    ItemStack stack = player.func_70694_bm();
    if(stack == null) {
      return false;
    }

    // regular bucket
    ItemStack result = FluidUtil.tryEmptyBucket(stack, tank, side);
    if(result != null) {
      if(!player.field_71075_bZ.field_75098_d) {
        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        PlayerHelper.spawnItemAtPlayer(player, result);
      }
      return true;
    }

    // universal bucket
    ItemStack copy = stack.func_77946_l();
    if(FluidUtil.tryEmptyFluidContainerItem(stack, tank, side, player)) {
      if(player.field_71075_bZ.field_75098_d) {
        // reset the stack that got modified
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, copy);
      }
      return true;
    }


    // prevent interaction of the item if it's a fluidcontainer. Prevents placing liquids when interacting with the tank
    return FluidContainerRegistry.isFilledContainer(stack) || stack.func_77973_b() instanceof IFluidContainerItem;
  }

  // at most 4
  public enum IOType implements IStringSerializable, EnumBlock.IEnumMeta {
    DRAIN;

    public final int meta;

    IOType() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
