package slimeknights.tconstruct.shared.inventory;

import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.network.InventoryCraftingSyncPacket;

// variant of InventoryCrafting that saves its itemstacks into the given inventory
public class InventoryCraftingPersistent extends InventoryCrafting {

  private final int length;
  private final Container eventHandler;
  private final IInventory parent;

  public InventoryCraftingPersistent(Container eventHandler, IInventory parent, int width, int height) {
    super(eventHandler, width, height);
    int k = width * height;

    assert (k == parent.func_70302_i_());

    this.parent = parent;
    this.length = k;
    this.eventHandler = eventHandler;
  }

  public int func_70302_i_() {
    return this.length;
  }

  public ItemStack func_70301_a(int index) {
    return index >= this.func_70302_i_() ? null : this.parent.func_70301_a(index);
  }

  public String getCommandSenderName() {
    return "container.crafting";
  }

  public boolean func_145818_k_() {
    return false;
  }

  public ItemStack getStackInSlotOnClosing(int index) {
    return null;
  }

  public ItemStack func_70298_a(int index, int count) {
    if(this.func_70301_a(index) != null) {
      ItemStack itemstack;

      if(this.func_70301_a(index).field_77994_a <= count) {
        itemstack = this.func_70301_a(index);
        this.func_70299_a(index, null);
        this.eventHandler.func_75130_a(this);
        return itemstack;
      }
      else {
        itemstack = this.func_70301_a(index).func_77979_a(count);

        if(this.func_70301_a(index).field_77994_a == 0) {
          this.func_70299_a(index, null);
        }

        this.eventHandler.func_75130_a(this);
        return itemstack;
      }
    }
    else {
      return null;
    }
  }

  public void func_70299_a(int index, ItemStack stack) {
    this.parent.func_70299_a(index, stack);
    this.eventHandler.func_75130_a(this);
  }

  @Override
  public void func_70296_d() {
    this.parent.func_70296_d();
    this.eventHandler.func_75130_a(this);

    TinkerTools.proxy.sendPacketToServerOnly(new InventoryCraftingSyncPacket());
  }

  public void func_174888_l() {
    // inventory can't clear the tile container
  }
}
