package slimeknights.tconstruct.shared.block;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.Random;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.utils.HarvestLevels;

public class BlockOre extends EnumBlock<BlockOre.OreTypes> {

  public static final PropertyEnum<OreTypes> TYPE = PropertyEnum.func_177709_a("type", OreTypes.class);

  public BlockOre() {
    this(Material.field_151576_e);
  }

  public BlockOre(Material material) {
    super(material, TYPE, OreTypes.class);

    func_149711_c(10f);
    setHarvestLevel("pickaxe", HarvestLevels.COBALT);
    func_149647_a(TinkerRegistry.tabWorld);
  }

  @SideOnly(Side.CLIENT)
  public EnumWorldBlockLayer func_180664_k() {
    return EnumWorldBlockLayer.CUTOUT_MIPPED;
  }

  public enum OreTypes implements IStringSerializable, EnumBlock.IEnumMeta {
    COBALT,
    ARDITE;

    public  final int meta;

    OreTypes() {
      meta = ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }

    @Override
    public int getMeta() {
      return meta;
    }
  }
}
