/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.tileentity;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.common.IInventoryGui;
import slimeknights.tconstruct.library.smeltery.ICast;
import slimeknights.tconstruct.library.tools.IPattern;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.tools.client.GuiPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.tileentity.TileTinkerChest;

public class TilePatternChest
extends TileTinkerChest
implements IInventoryGui {
    public TilePatternChest() {
        super("gui.patternchest.name", 256, 1);
    }

    public Container createContainer(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new ContainerPatternChest(inventoryplayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer, World world, BlockPos pos) {
        return new GuiPatternChest(inventoryplayer, world, pos, this);
    }

    public boolean isItemValidForSlot(int slot, ItemStack itemstack) {
        int i;
        if (itemstack == null || !(itemstack.getItem() instanceof IPattern) && !(itemstack.getItem() instanceof ICast)) {
            return false;
        }
        Item part = Pattern.getPartFromTag(itemstack);
        boolean hasContents = false;
        for (i = 0; i < this.getSizeInventory(); ++i) {
            if (!this.isStackInSlot(i)) continue;
            hasContents = true;
            break;
        }
        if (!hasContents) {
            return true;
        }
        boolean castChest = this.isCastChest();
        if (castChest && !(itemstack.getItem() instanceof ICast)) {
            return false;
        }
        if (!(castChest || itemstack.getItem() instanceof IPattern && !(itemstack.getItem() instanceof ICast))) {
            return false;
        }
        if (part == null) {
            for (i = 0; i < this.getSizeInventory(); ++i) {
                ItemStack inv = this.getStackInSlot(i);
                if (inv == null || !ItemStack.areItemsEqual((ItemStack)itemstack, (ItemStack)inv) || !ItemStack.areItemStackTagsEqual((ItemStack)itemstack, (ItemStack)inv)) continue;
                return false;
            }
            return true;
        }
        for (i = 0; i < this.getSizeInventory(); ++i) {
            Item slotPart = Pattern.getPartFromTag(this.getStackInSlot(i));
            if (slotPart == null) continue;
            if (this.getStackInSlot(i).getItem() != itemstack.getItem()) {
                return false;
            }
            if (slotPart != part) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        if (this.isCastChest()) {
            return "gui.castchest.name";
        }
        return super.getName();
    }

    public boolean isCastChest() {
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            if (this.getStackInSlot(i) == null || !(this.getStackInSlot(i).getItem() instanceof ICast)) continue;
            return true;
        }
        return false;
    }
}

